/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.text.diff.CommandVisitor;
import org.apache.commons.text.diff.ReplacementsFinder;
import org.apache.commons.text.diff.ReplacementsHandler;
import org.apache.commons.text.diff.StringsComparator;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ReplacementsFinderTest {
    private SimpleHandler handler = null;

    @BeforeEach
    public void setUp() {
        this.handler = new SimpleHandler();
    }

    public static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{"branco", "blanco", 1, new Character[]{Character.valueOf('r')}, new Character[]{Character.valueOf('l')}}), Arguments.of((Object[])new Object[]{"test the blocks before you use it", "try the blocks before you put it", 25, new Character[]{Character.valueOf('e'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('s'), Character.valueOf('e')}, new Character[]{Character.valueOf('r'), Character.valueOf('y'), Character.valueOf('p'), Character.valueOf('t')}}));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testReplacementsHandler(String left, String right, int skipped, Character[] from, Character[] to) {
        StringsComparator sc = new StringsComparator(left, right);
        ReplacementsFinder replacementFinder = new ReplacementsFinder((ReplacementsHandler)this.handler);
        sc.getScript().visit((CommandVisitor)replacementFinder);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.handler.getSkipped()).as("Skipped characters do not match", new Object[0])).isEqualTo(skipped);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])this.handler.getFrom().toArray(new Character[0]), (Object[])from, (String)"From characters do not match");
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])to, (Object[])this.handler.getTo().toArray(new Character[0]), (String)"To characters do not match");
    }

    private class SimpleHandler
    implements ReplacementsHandler<Character> {
        private int skipped = 0;
        private final List<Character> from = new ArrayList<Character>();
        private final List<Character> to = new ArrayList<Character>();

        SimpleHandler() {
        }

        public int getSkipped() {
            return this.skipped;
        }

        public List<Character> getFrom() {
            return this.from;
        }

        public List<Character> getTo() {
            return this.to;
        }

        public void handleReplacement(int skipped, List<Character> from, List<Character> to) {
            this.skipped += skipped;
            this.from.addAll(from);
            this.to.addAll(to);
        }
    }
}

