/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.http.localserver;

import org.apache.http.HttpHost;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.junit.After;
import org.junit.Before;

public abstract class HttpAsyncTestBase extends AbstractAsyncTest{

    protected HttpAsyncClientBuilder clientBuilder;
    protected CloseableHttpAsyncClient httpclient;

    public HttpAsyncTestBase() {
        super();
    }

    public HttpAsyncTestBase(final ProtocolScheme scheme) {
        super(scheme);
    }

    public HttpHost start() throws Exception {
        final HttpHost serverEndpoint = startServer();

        this.httpclient = this.clientBuilder.build();
        this.httpclient.start();

        return serverEndpoint;
    }

    @Before @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientBuilder = HttpAsyncClientBuilder.create();
        this.clientBuilder.setConnectionManager(this.connMgr);
    }

    @After  @Override
    public void shutDown() throws Exception {
        if (this.httpclient != null) {
            this.httpclient.close();
        }
        super.shutDown();
    }

}
