/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.health;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.metrics.health.HealthCheckResult;
import org.apache.servicecomb.foundation.metrics.health.HealthChecker;

public class HealthCheckerManager {
    private final Map<String, HealthChecker> healthCheckers = new ConcurrentHashMap<String, HealthChecker>();
    private static final HealthCheckerManager INSTANCE = new HealthCheckerManager();

    public static HealthCheckerManager getInstance() {
        return INSTANCE;
    }

    private HealthCheckerManager() {
        List checkers = SPIServiceUtils.getAllService(HealthChecker.class);
        for (HealthChecker checker : checkers) {
            this.register(checker);
        }
    }

    public void register(HealthChecker checker) {
        this.healthCheckers.put(checker.getName(), checker);
    }

    public void unregister(String name) {
        this.healthCheckers.remove(name);
    }

    public Map<String, HealthCheckResult> check() {
        return this.healthCheckers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((HealthChecker)e.getValue()).check()));
    }
}

