/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.common.accessLog.core.parser.AccessLogPatternParser;
import org.apache.servicecomb.common.accessLog.core.parser.impl.VertxRestAccessLogPatternParser;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;

public class AccessLogGenerator {
    private final AccessLogItem<RoutingContext>[] accessLogItems;
    private final AccessLogPatternParser<RoutingContext> logPatternParser = new VertxRestAccessLogPatternParser();

    public AccessLogGenerator(String rawPattern) {
        List<AccessLogItem<RoutingContext>> accessLogItemList = this.logPatternParser.parsePattern(rawPattern);
        this.accessLogItems = (AccessLogItem[])Iterables.toArray(accessLogItemList, AccessLogItem.class);
    }

    public String generateServerLog(ServerAccessLogEvent accessLogEvent) {
        StringBuilder log = new StringBuilder(128);
        for (AccessLogItem<RoutingContext> accessLogItem : this.getAccessLogItems()) {
            accessLogItem.appendServerFormattedItem(accessLogEvent, log);
        }
        return log.toString();
    }

    public String generateClientLog(InvocationFinishEvent finishEvent) {
        StringBuilder log = new StringBuilder(128);
        for (AccessLogItem<RoutingContext> accessLogItem : this.getAccessLogItems()) {
            accessLogItem.appendClientFormattedItem(finishEvent, log);
        }
        return log.toString();
    }

    @VisibleForTesting
    AccessLogItem<RoutingContext>[] getAccessLogItems() {
        return this.accessLogItems;
    }
}

