/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import com.google.common.eventbus.Subscribe;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.servicecomb.governance.MatchersManager;
import org.apache.servicecomb.governance.event.GovernanceConfigurationChangedEvent;
import org.apache.servicecomb.governance.event.GovernanceEventManager;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableMap;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGovernanceHandler<PROCESSOR, POLICY extends AbstractPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGovernanceHandler.class);
    protected final DisposableMap<PROCESSOR> processors;
    private final Object lock = new Object();
    protected MatchersManager matchersManager;
    protected MeterRegistry meterRegistry;

    protected AbstractGovernanceHandler() {
        GovernanceEventManager.register(this);
        this.processors = new DisposableMap(this::onConfigurationChanged);
    }

    @Autowired
    public void setMatchersManager(MatchersManager matchersManager) {
        this.matchersManager = matchersManager;
    }

    @Autowired(required=false)
    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PROCESSOR getActuator(GovernanceRequestExtractor requestExtractor) {
        POLICY policy = this.matchPolicy(requestExtractor);
        if (policy == null) {
            return null;
        }
        String key = this.createKey(requestExtractor, policy);
        if (key == null) {
            return null;
        }
        Disposable<PROCESSOR> processor = this.processors.get(key);
        if (processor == null) {
            Object object = this.lock;
            synchronized (object) {
                processor = this.processors.get(key);
                if (processor == null) {
                    processor = this.createProcessor(key, requestExtractor, policy);
                    this.processors.put(key, processor);
                }
            }
        }
        return (PROCESSOR)processor.get();
    }

    protected abstract String createKey(GovernanceRequestExtractor var1, POLICY var2);

    protected abstract POLICY matchPolicy(GovernanceRequestExtractor var1);

    protected abstract Disposable<PROCESSOR> createProcessor(String var1, GovernanceRequestExtractor var2, POLICY var3);

    protected void onConfigurationChanged(String key) {
        Disposable processor = (Disposable)this.processors.remove(key);
        if (processor != null) {
            LOGGER.info("remove governance processor {}", (Object)key);
            processor.dispose();
        }
    }

    @Subscribe
    public void onDynamicConfigurationListener(GovernanceConfigurationChangedEvent event) {
        event.getChangedConfigurations().forEach(this::onConfigurationChanged);
    }
}

