/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views.tree;

import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;

public class TestEvaluationTree {
    private TypeTreeNode root;

    public void createTree(CAS cas) {
        Type falsePositiveType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.FalsePositive");
        Type falseNegativeType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.FalseNegative");
        Type truePositiveType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.TruePositive");
        if (falsePositiveType == null || falseNegativeType == null) {
            return;
        }
        this.root = new TypeTreeNode(cas, null, cas.getAnnotationType());
        TypeTreeNode fproot = new TypeTreeNode(cas, (ITreeNode)this.root, falsePositiveType);
        TypeTreeNode fnroot = new TypeTreeNode(cas, (ITreeNode)this.root, falseNegativeType);
        TypeTreeNode tproot = new TypeTreeNode(cas, (ITreeNode)this.root, truePositiveType);
        this.addEvalNodes(cas, falsePositiveType, fproot);
        this.addEvalNodes(cas, falseNegativeType, fnroot);
        this.addEvalNodes(cas, truePositiveType, tproot);
        this.root.addChild((ITreeNode)fproot);
        this.root.addChild((ITreeNode)fnroot);
        this.root.addChild((ITreeNode)tproot);
    }

    private void addEvalNodes(CAS cas, Type falsePositiveType, TypeTreeNode fproot) {
        FSIterator iter = cas.getAnnotationIndex(falsePositiveType).iterator();
        while (iter.isValid()) {
            FeatureStructure fs = iter.get();
            if (fs instanceof AnnotationFS) {
                AnnotationFS a = (AnnotationFS)fs;
                Feature original = fs.getType().getFeatureByBaseName("original");
                FeatureStructure originalfs = fs.getFeatureValue(original);
                TypeTreeNode parentTypeNode = this.containsTypeNode(fproot, originalfs);
                if (parentTypeNode == null && originalfs != null) {
                    parentTypeNode = new TypeTreeNode(cas, (ITreeNode)fproot, originalfs.getType());
                    fproot.addChild((ITreeNode)parentTypeNode);
                }
                AnnotationTreeNode newNode = new AnnotationTreeNode(cas, (ITreeNode)parentTypeNode, a);
                if (parentTypeNode != null) {
                    parentTypeNode.addChild((ITreeNode)newNode);
                } else {
                    RutaAddonsPlugin.error(new IllegalArgumentException("Trying to display unknown type for " + String.valueOf(a)));
                }
            }
            iter.moveToNext();
        }
    }

    private TypeTreeNode containsTypeNode(TypeTreeNode fproot, FeatureStructure originalfs) {
        ITreeNode[] children;
        for (ITreeNode each : children = fproot.getChildren()) {
            TypeTreeNode node;
            if (!(each instanceof TypeTreeNode) || !(node = (TypeTreeNode)each).getType().equals((Object)originalfs.getType())) continue;
            return node;
        }
        return null;
    }

    public ITreeNode getRoot() {
        return this.root;
    }
}

