
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method replaceWholeText substitutes the a specified text for the text of 
 *  the current node and all logically-adjacent text nodes.  This method raises
 *  a NO_MODIFICATION_ALLOWED_ERR if one of the Text nodes being replaced is readonly.
 *  
 *  Invoke replaceWholeText on an existing text node with newly created text and Entityreference
 *  nodes (whose replacement text is a character entity reference) appended as children of its parent element node.  
 *  Where the nodes to be removed are read-only descendants of an EntityReference, the EntityReference 
 *         must be removed instead of the read-only nodes. Only if any EntityReference to be removed has 
 *         descendants that are not EntityReference, Text, or CDATASection nodes, the replaceWholeText 
 *         method must fail, raising a NO_MODIFICATION_ALLOWED_ERR. Verify that the method does not raise
 *         an exception and verify the content of the returned text node.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Text3-replaceWholeText">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Text3-replaceWholeText</a>
*/
public final class textreplacewholetext06 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public textreplacewholetext06(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware,
org.w3c.domts.DocumentBuilderSetting.expandEntityReferences
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList itemList;
      Element elementStrong;
      Text textNode;
      EntityReference erefNode;
      Text replacedText;
      Node appendedChild;
      String nodeValue;
      doc = (Document) load("hc_staff", false);
      itemList = doc.getElementsByTagName("strong");
      elementStrong = (Element) itemList.item(0);
      textNode = doc.createTextNode("New Text");
      erefNode = doc.createEntityReference("beta");
      appendedChild = elementStrong.appendChild(textNode);
      appendedChild = elementStrong.appendChild(erefNode);
      textNode = (Text) elementStrong.getFirstChild();
      replacedText = textNode.replaceWholeText("New Text and Cdata");
      nodeValue = textNode.getNodeValue();
      assertEquals("textreplacewholetext06", "New Text and Cdata", nodeValue);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/textreplacewholetext06";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(textreplacewholetext06.class, args);
   }
}

