//****************************************************************************
//
// STL compliant source code
//
//****************************************************************************

#include<string>
#include<iostream>
#include<vector>
#include<sstream>

using namespace std;

#include "SourceLine.h"
#include "stdio.h"
#include "cutils.h"

SourceLine::SourceLine() {
	line_no = 0;
	source_line_no = 0;
	source = NULL;
}

SourceLine::~SourceLine(){
}

SourceLine::SourceLine(const SourceLine& cl){
	filename = cl.filename;
	line_no = cl.line_no;
	source_line_no = cl.source_line_no;
	text = cl.text;
	source = cl.source;
}

SourceLine& SourceLine::operator = (const SourceLine& gr){
	if (&gr == this) {
		return *this;
	}
	filename = gr.filename;
	line_no = gr.line_no;
	text = gr.text;
	source_line_no = gr.source_line_no;
	source = gr.source;
	return *this;
}

void SourceLine::showPosPointer(int pos, ostream& out) {
	char number[50];
	sprintf(number, "%d", source_line_no);
	int nbspc = filename.length() + strlen(number) + 5 + pos - 1;
	int prefix = 0;
	for (int i = 0; i < text.length(); i++) {
		char ch = text[i];
		if (ch == ' ') {
			prefix++;
		} else if (ch == '\t') {
			prefix = (prefix/8 + 1)*8;
		} else {
			break;
		}
	}
	nbspc -= prefix;
	for (int i = 0; i < nbspc; i++) out << " ";
	out << "^";
}

const string& SourceLine::getFileName() {
	return getSource()->getFileName();
}

int operator==(const SourceLine& a,const SourceLine& b){
    return (
	a.filename == b.filename &&
	a.line_no == b.line_no &&
	a.text == b.text &&
	a.source_line_no == b.source_line_no
    );
}

ostream& operator<<(ostream& out, SourceLine d){
	out << d.filename.c_str() <<" ("<< d.source_line_no << ")";
	if (!gle_onlyspace(d.text)) {
		string temp = d.text;
		str_trim_both(temp);
		out << " |" << temp << "|" << endl;
	}
	return out;
}

_GLESource::_GLESource() {
}

_GLESource::~_GLESource() {
}

void _GLESource::attach(_GLESource& g) {
	_GLESource::iterator itg = g.begin();
	while(itg != g.end()){
		itg->setSource(this);
		itg++;
	}
}

