// STL compliant include
#ifndef INCLUDE_SourceLine
#define INCLUDE_SourceLine

#include <list>

class _GLESource;

class SourceLine {
public:
	// the global line number for GLE every line of gle source needs its own
	// unique line number thus included files must have this set
	int line_no;

	// the real line number when referencing the source file
	int source_line_no;

	string filename;
	string text;
	_GLESource* source;
public:
	SourceLine();
	SourceLine(const SourceLine& cl);
	~SourceLine();
	SourceLine& operator = (const SourceLine& gr);
	void showPosPointer(int pos, ostream& out);
	const string& getFileName();
	inline void setSource(_GLESource* src) { source = src; }
	inline _GLESource* getSource() { return source; }
};

int operator==(const SourceLine& a , const SourceLine& b);

inline void copy( SourceLine& a , const SourceLine& b) {
    a = b;
}

ostream& operator<<(ostream& out, SourceLine d);

class _GLESource : public std::list<SourceLine> {
protected:
	string m_FName;
public:
	_GLESource();
	~_GLESource();
	inline const string& getFileName() { return m_FName; }
	inline void setFileName(const char* fname) { m_FName = fname; }
	inline void setFileName(const string& fname) { m_FName = fname; }
	void attach(_GLESource& other);
};

typedef std::list<SourceLine>::iterator	_itGLESource;
typedef std::list<SourceLine>::const_iterator _citGLESource;

#endif

