
/*
 * 2004 Jan Struyf
 *
 */

#include "../basicconf.h"
#include "img2ps.h"

/*
 * JPEG
 */

#define M_SOF0  0xC0
#define M_SOF1  0xC1
#define M_SOF2  0xC2
#define M_SOF3  0xC3
#define M_SOF5  0xC5
#define M_SOF6  0xC6
#define M_SOF7  0xC7
#define M_SOF9  0xC9
#define M_SOF10 0xCA
#define M_SOF11 0xCB
#define M_SOF13 0xCD
#define M_SOF14 0xCE
#define M_SOF15 0xCF
#define M_SOI   0xD8
#define M_EOI   0xD9
#define M_SOS   0xDA
#define M_EXIF  0xE1
#define M_COM   0xFE

GLEJPEG::GLEJPEG() : GLEFileBitmap() {
	m_Encoding = GLE_BITMAP_JPEG;
}

GLEJPEG::~GLEJPEG() {
}

int GLEJPEG::readImageSize() {
	m_Precision = fgetc(m_In);
	m_Height = read16BE();
	m_Width = read16BE();
	m_Components = fgetc(m_In);
	if (m_Components == 1) {
		setMode(GLE_BITMAP_GRAYSCALE);
	} else {
		setMode(GLE_BITMAP_RGB);
	}
	return GLE_IMAGE_ERROR_NONE;
}

int GLEJPEG::readHeader() {
	int hbyte = fgetc(m_In);
	if (hbyte != 0xff || fgetc(m_In) != M_SOI){
		return GLE_IMAGE_ERROR_DATA;
	}
	int nbsec = 0;
	int marker = 0;
	int nbpadding = 0;
	while (nbsec < 20 && !feof(m_In)) {
		/* Skip padding at start of section */
		for (int i = 0; i < 7; i++) {
			marker = fgetc(m_In);
			if (feof(m_In)) {
				/* End of file */
				return GLE_IMAGE_ERROR_NONE;
			}
			if (marker != 0xff) {
				break;
			} else {
				nbpadding++;
			}
		}
		if (marker == 0xff || nbpadding == 0) {
			return GLE_IMAGE_ERROR_DATA;
		}
		/* Just before section */
		int crpos = ftell(m_In);
  		/* Read section length */
		int size = read16BE();
		if (size < 2) {
			return GLE_IMAGE_ERROR_DATA;
		}
		/* Size info? */
		switch (marker) {
			case M_SOF0:
			case M_SOF1:
			case M_SOF2:
			case M_SOF3:
			case M_SOF5:
			case M_SOF6:
			case M_SOF7:
			case M_SOF9:
			case M_SOF10:
			case M_SOF11:
			case M_SOF13:
			case M_SOF14:
			case M_SOF15:
 				readImageSize();
		}
		/* Skip till after section */
		fseek(m_In, crpos+size, SEEK_SET);
		nbsec++;
	}
	return GLE_IMAGE_ERROR_NONE;
}

int GLEJPEG::coded(GLEByteStream* output) {
	fseek(m_In, 0, SEEK_SET);
	while (!feof(m_In)) {
		output->sendByte(fgetc(m_In));
	}
	return GLE_IMAGE_ERROR_NONE;
}
