
#ifndef INCLUDE_CUTILS_H
#define INCLUDE_CUTILS_H

bool gle_onlyspace(const string& s);
bool gle_isnumber(const char *s);

bool gle_isalphanum(char ch);

int gle_isnan(double v);
int gle_isinf(double v);

const char* str_skip_brackets(const char* s, int ch1, int ch2);

char* gle_strupr(char* s);
char* gle_strlwr(char *s);

int str_skip_brackets(const string& s, int pos, int ch1, int ch2);

// for compatibility between different compilers
bool str_i_equals(const char* s1, const char* s2);
bool str_ni_equals(const char* s1, const char* s2, int max);
int str_i_cmp(const char* s1, const char* s2);

char* str_i_str(const char* haystack, const char* needle);
int str_i_str(const string& haystack, const char* needle);
int str_i_str(const string& haystack, int from, const char* needle);

bool str_i_equals(const string& s1, const string& s2);

bool str_contains(const char* str, char ch);

void str_prefix(int count, char ch, string* str);

void str_to_uppercase(const string& input, string& output);

void str_to_uppercase(string& output);

void str_trim_both(string& str);

void str_trim_right(string& str);

void str_trim_left(string& str);

int str_starts_with_trim(string& str, const char* test);

bool str_starts_with(const string& str, const char* find);

bool str_i_ends_with(const string& str, const char* find);

void str_remove_quote(string& str);

void str_try_add_quote(string& str);

void str_parse_get_next(const string& strg, const char* find, string& res);

void gle_int_to_string_bin(int value, string* binary);

void gle_int_to_string(int value, string* str);

int gle_double_digits(double value, int prec);

int gle_int_digits(int value);

char *un_quote(char *cts);

int lastchar(char *s, char c);

int gle_pow_ii(int x, int n);

int f_pow_ii(int* ap, int* bp);

double f_r_sign(double* a, double* b);

int f_i_sign(int *a, int* b);

void str_delete_start(string& str, char ch);

void str_replace_start(string& str, const char* find, const char* repl);

void str_replace_all(char* str, const char* find, const char* repl);
void str_replace_all(string& str, const char* find, const char* repl);

void str_get_system_error(ostream& error);

int gle_round_int(double val);

void strip_crlf(char* str);

#endif
