
#include "all.h"
#include "tokens/stokenizer.h"
#include "SourceLine.h"
#include "tokens/Tokenizer.h"
#include "mem_limits.h"
#include "token.h"
#include "core.h"
#include "var.h"
#include "glearray.h"
#include "polish.h"
#include "pass.h"
#include "file_io.h"
#include "gprint.h"
#include "mygraph.h"
#include "run.h"
#include "cmdline.h"
#include "config.h"
#include "drawit.h"
#include "cutils.h"

#define dbg if (gle_debug>0)
extern int gle_debug;
extern int this_line;
int trace_on;
int *(*gpcode)[];   /* gpcode is a pointer to an array of poiter to int */
int (*gplen)[];   /* gpcode is a pointer to an array of int */
int ngpcode=0;
int ngerror;
extern int last_line;

void expand_pcode(int i, int *j);
char *dr_nextline(int *srclin);
void dr_init(void);
int getch(void);

int abort_flag;
static char inbuff[300];

void g_close();

string g_OutputFile;

int gle_is_open();

const string& get_output_file() {
	return g_OutputFile;
}

void Renumber(_GLESource &g) {
	_itGLESource itg = g.begin();
	int i = 1;
	while(itg != g.end()){
		itg->line_no = i++;
		itg++;
	}
}

void do_set_vars() {
	var_def("PI", GLE_PI);
	var_def("XGMIN", 0.0);
	var_def("YGMIN", 0.0);
	var_def("XGMAX", 0.0);
	var_def("YGMAX", 0.0);
	var_def("X2GMIN", 0.0);
	var_def("Y2GMIN", 0.0);
	var_def("X2GMAX", 0.0);
	var_def("Y2GMAX", 0.0);
	var_def("ZGMIN", 0.0);
	var_def("ZGMAX", 0.0);
}

/*---------------------------------------------------------------------------*/

void output_error(ParserError& err) {
	g_set_error_column(-1);
	if (err.hasFlag(TOK_PARSER_ERROR_ATEND)) {
		// Otherwise, the message would be "unexpected end of file"
		err.setMessage("unexpected end of line");
	}
	if (err.hasFlag(TOK_PARSER_ERROR_PSTRING)) {
		if (err.file() == "") {
			gprint(string(">> Error: ")+err.msg()+"\n");
		} else {
			string err_str;
			err.toString(err_str);
			gprint(string(">> Error: ")+err_str+"\n");
		}
		if (err.getColumn() != -1) {
			gprint(string(">> In: '")+err.getParserString()+"'\n");
			stringstream pos_strm;
			pos_strm << ">>";
			for (int i = 0; i < err.getColumn()+5; i++) {
				pos_strm << " ";
			}
			pos_strm << "^" << endl;
			gprint(pos_strm.str());
		}
	} else {
		if (err.file() == "") {
			// Error in the GLE file
			g_set_error_column(err.getColumn());
			gprint(string(">> Error: ")+err.msg()+"\n");
		} else {
			// Error while reading a data file
			string err_str;
			err.toString(err_str);
			gprint(string(">> Error: ")+err_str+"\n");
		}
	}
}

void output_error_cerr(ParserError& err) {
	// Used by GLE "as a calculator", i.e., if no GLE file is active
	if (err.hasFlag(TOK_PARSER_ERROR_ATEND)) {
		// Otherwise, the message would be "unexpected end of file"
		err.setMessage("unexpected end of line");
	}
	if (err.hasFlag(TOK_PARSER_ERROR_PSTRING)) {
		cerr << ">> Error: " << err.msg() << endl;
		if (err.getColumn() != -1) {
			cerr << ">> In: '" << err.getParserString() << "'" << endl;
			stringstream pos_strm;
			pos_strm << ">>";
			for (int i = 0; i < err.getColumn()+5; i++) {
				pos_strm << " ";
			}
			pos_strm << "^" << endl;
			cerr << pos_strm.str();
		}
	} else {
		cerr << ">> Error: " << err.msg() << endl;
	}
}

void DrawIt(const string& output_file, _GLESource &gle_txt, CmdLineObj* cmdline, bool silent) {
	abort_flag = false;
	ngerror = 0;
	last_line = 0;
	if (!silent) {
		printf("GLE %s [%s]-C", __GLEVN__, gle_txt.getFileName().c_str());
		fflush(stdout);
	}
	g_OutputFile = output_file;
	g_clear();
	mark_clear();
	sub_clear();
	name_clear();
	clear_run();
	f_init();
	if (cmdline != NULL) {
		int devtype = g_get_device();
		if (devtype == GLE_DEVICE_PS) {
			g_set_fullpage(true);
		} else {
			g_set_fullpage(cmdline->hasOption(GLE_OPT_FULL_PAGE));
		}
	}
	g_set_pagesize(gle_config_papersize());
	g_set_margins(gle_config_margins());
	do_set_vars();

	GLEPcodeList pc_list;
	GLEPcode pcode(&pc_list);

	int maxpcode=0;
	expand_pcode(gle_txt.size(),&maxpcode);
	ngpcode=0;

	GLEPolish polish;
	polish.initTokenizer();

	// Create tokenizer
	GLEParser parser(&polish);
	parser.initTokenizer();

	set_global_parser(&parser);

	_itGLESource lscli = gle_txt.begin();
	while(lscli != gle_txt.end()){
		// call passt to convert the tokens into PCode
		// pcode is simply numbers that instruct the drawing
		// engine which commands to draw

		// cout << "Line = " << *lscli;
		parser.setString(lscli->text.c_str());

		try {
			parser.passt(*lscli, pcode);
		} catch (ParserError err) {
			output_error(err);
		}

		bool add_pcode = true;
		if (parser.hasSpecial(GLE_PARSER_INCLUDE)){
			// this is a file to include load the file and insert it into gle_txt here
			_GLESource included_text;
			if (!text_load_include(parser.getInclude(),included_text,lscli->line_no)) {
				gprint("Error can't open include file %s\n",parser.getInclude().c_str());
				do_wait_for_enter_exit(1);
			}
			// now insert here: calling splice ensures pointer remain valid or so says the STL docs
			_itGLESource Save = lscli;
			Save--;
			// this puts in before lscli
			gle_txt.attach(included_text);
			gle_txt.splice(lscli, included_text);
			gle_txt.erase(lscli); // dont need the include line anymore
			Renumber(gle_txt);    // need to renumber all the global line numbers this is kninda kludegy VL
			lscli = Save;         // put to first line of included text
			cout << "{" << parser.getInclude() << "}";
			// don't need this pcode
			add_pcode = false;
		}
		if (add_pcode){
			#ifdef NEW_WAY
			// not working due to need for global pcode!
			GlobalPCode.push_back(PCode);
			#else
			// copy the pcode into the global buffer
			if (ngpcode > maxpcode) expand_pcode(ngpcode*2,&maxpcode);
			(*gpcode)[++ngpcode] = pcode.size() == 0 ? NULL : (int*) myallocz(pcode.size()*sizeof(char *));
			(*gplen)[ngpcode] = pcode.size();
			memcpy((*gpcode)[ngpcode],&pcode[0],pcode.size()*sizeof(int));
			#endif
		}
		pcode.clear();
		lscli++;
	}
	try {
		parser.checkmode();
		if (ngerror > 0){
			reset_new_error(true);
			g_message("\n>> Errors, aborting.\n");
			do_wait_for_enter_exit(1);
		}
		//
		// -- now run the pcode in the driver
		//
		if (!silent) printf("-R-");
		if (ngpcode != gle_txt.size()) {
			cout << "error pcode and text size mismatch"<<endl;
			cout << "pcode size = " << ngpcode <<" text size = "<<gle_txt.size()<<endl;
		}
		token_space();
		int endp = 0;
		// should get rid of gle_txt here!
		lscli = gle_txt.begin();
		for (int i=1;i<=ngpcode;i++){
			this_line = i;
			//cout << i << " ";
			int Oldi = i;
			do_pcode(*lscli,&i,(*gpcode)[i],(*gplen)[i],&endp);
			//cout << i << " " << *lscli;
			// need to advance here since do_pcode may call for line skipping
			advance(lscli,i-Oldi+1);
		}
	} catch (ParserError err) {
		output_error(err);
	}
	if (!gle_is_open()) {
		// If .gle file is empty, create empty postscript file
		g_set_size(10, 10, false);
		g_open(get_output_file(), gle_txt.getFileName());
	}
	set_global_parser(NULL);
	bool has_console = g_reset_message();
	g_close();
	g_set_console_output(has_console);
}

bool text_load_include(const string& fname, _GLESource &SL, int global_line_no) {
	string fullname = GetActualFilename(fname);
	if (fullname == "") {
		//printf("ERROR: File \"%s\" is not found.\nExiting.\n",fname.c_str());
		return false;
	} else {
		return text_load(fullname, fname, SL, global_line_no);
	}
}

bool text_load(const string& fname, _GLESource &SL, int global_line_no) {
	return text_load(fname, fname, SL, global_line_no);
}

bool text_load(const string& fullname, const string& fname, _GLESource &SL, int global_line_no) {
	// -- load the gle file called by main program and the include command
	//    fname .. the filename
	//    SL    .. STL list of source lines
	//    global_line_no is needed for renumbering include file...
	// returns true upon success false if it cant find the file
	//
	if (IsDirectory(fullname)) {
		// printf("ERROR: File \"%s\" is a directory.\nExiting.\n",fname.c_str());
		return false;
	}
	std::ifstream file;
	file.open(fullname.c_str());
	if (!file.is_open()){
		// printf("ERROR File %s is not found.\nExiting.\n",fullname.c_str());
		return false;
	}
	//
	// -- load the file and rememeber to look for continuation character
	//
	size_t line_no = 1;
	const char CONT_CHAR = '&';  // should be a global define somewhere??
	bool cont = false;
	string inbuff;
	SL.setFileName(fname);
	while(!file.eof()){
		string linbuff;
		getline(file, linbuff);
		// trim is required to make position indicator in error messages appear correctly
		str_trim_both(linbuff);
		if (cont) {
			// -- splice this string into inbuff at location of '&'
			inbuff.replace(inbuff.rfind(CONT_CHAR),linbuff.length(),linbuff);
			cont = false;
		} else {
			inbuff = linbuff;
		}
		// -- search for continuation character '&' if found
		if (inbuff.length() > 0 && inbuff.at(inbuff.length()-1) == CONT_CHAR) {
			// -- continuation
			cont = true;
		}
		if (!cont || file.eof()){
			SourceLine sline;
			sline.source_line_no = line_no;
			sline.line_no        = global_line_no;
			sline.filename       = fname;
			sline.text           = inbuff;
			sline.source         = &SL;
			// cout << SourceLine << endl;
			SL.push_back(sline);
			global_line_no++;
		}
		line_no++;
	}
	file.close();
	return true;
}

void include_file(const string& fname, _itGLESource igs, _GLESource &gle_txt) {
	_GLESource temp;
	text_load_include(fname, temp);
	printf("-{%s}",fname.c_str());
	gle_txt.insert(igs,temp.begin(),temp.end());
	igs++;
}

void expand_pcode(int ngtxt,int *maxpcode) {
        int *a,*b;
        a = (int*) myallocz((ngtxt+10)*sizeof(char *));
        b = (int*) myallocz((ngtxt+10)*sizeof(char *));
        if (gpcode!=0) {
                memcpy(a,gpcode,(*maxpcode + 4)*sizeof(char *));
                memcpy(b,gplen,(*maxpcode + 4)*sizeof(char *));
                myfrees(gpcode,"gpcode2");
                myfrees(gplen,"gplen");
        }
        gpcode = (int *(*)[]) a;
        gplen = (int (*)[]) b;
        *maxpcode = ngtxt+1;
}

