#ifndef INCLUDE_FILE_IO
#define INCLUDE_FILE_IO

#ifdef __UNIX__
	#define READ_BIN "r"
	#define WRITE_BIN "w"
#endif

#ifdef __WIN32__
	#define READ_BIN "rb"
	#define WRITE_BIN "wb"
#endif

#if defined(__OS2__) && defined(__EMX__)
	#define READ_BIN "rb"
	#define WRITE_BIN "wb"
#endif

#ifndef IN_FILE_IO_H
	extern string PATH_SEP;
	extern string DIR_SEP;
#endif

char *fontdir(char *fname);
char *line(int i);

void CopyGLETop(char* buf);
string GetActualFilename(string fname);
void FillIncludePaths(vector<string>& IP);
void StripDirSep(string& fname);
void AddDirSep(string& fname);
void GetExtension(const string& fname, string& ext);
void GetMainName(const string& fname, string& name);
void SplitFileName(const string& fname, string& dir, string& name);
void SplitFileNameNoDir(const string& fname, string& name);
void GetDirName(const string& fname, string& dir);
void EnsureMkDir(const string& dir);
bool TryDeleteFile(const string& fname);
bool DeleteFileWithExt(const string& fname, const char* ext);
int ReadFileLine(istream& file, string& line);
int ReadFileLineAllowEmpty(istream& file, string& line);
bool IsDirectory(const string& fname);
bool GLEMoveFile(const string& from, const string& to);
bool GLECopyFile(const string& from, const string& to);
bool GLEGetCrDir(string* name);
bool GLEGetCrDirWin32(string* name);
bool GLEChDir(const string& dir);
void GLEFindFiles(const string& dir, const vector<string>& tofind, vector<string*>& result);
int GLESystem(const string& cmd, bool wait = true);
int GLERun(const string& cmd, string& result);
int GLESendSocket(const string& commands);
bool GetExeName(const char* appname, string& exe_name);
void GLESetGLETop(const string& cmdline);
bool GLEFileExists(const string& fname);
void GLESleep(int msec);
void StripPathComponents(string* fname, int nb);
bool IsAbsPath(string& path);

#define GLE_SYSTEM_OK    0
#define GLE_SYSTEM_ERROR 1

class StreamTokenizerMax {
protected:
	char* m_LastToken;
	int m_Sep, m_Max, m_IsOK;
	ifstream m_File;
public:
	StreamTokenizerMax(const string& fname, int sep, int max);
	~StreamTokenizerMax();
	bool hasMoreTokens();
	bool isSepChar(char ch);
	const char* nextToken();
	void readNextToken();
	void close();
	inline ifstream& getFile() { return m_File; }
};

#endif
