
#include "all.h"
#include "SourceLine.h"
#include "gprint.h"

#ifdef VAXC
double myatan2(double y, double x);
#endif

void showpcode(int *p)
{
	union {int l; short s[2];} bth;
	int i;

	gprint("GP> ");
	for (i=0;i<12;i++) {
		bth.l = *(p++);
		gprint("%x %x  ",bth.s[0],bth.s[1]);
	}
	gprint("\n");
}
void polar_xy(double r, double angle, double *dx, double *dy)
{
	*dx = r*cos(angle*GLE_PI/180);
	*dy = r*sin(angle*GLE_PI/180);
}
void polar_xy(double rx, double ry, double angle, double *dx, double *dy)
{
	*dx = rx*cos(angle*GLE_PI/180);
	*dy = ry*sin(angle*GLE_PI/180);
}

void xy_polar(double dx,double dy,double *radius,double *angle)
{
	if (dx==0 && dy==0) {
		gprint("Cannot work out angle of zero length vector\n");
		return;
	}
	if (dx==0) {
		*angle = 90;
		if (dy<0) *angle = -90;
	} else {
		*angle = myatan2(dy,dx)*180/GLE_PI;
	}
	*radius = sqrt(dx*dx + dy*dy);
}

void fpolar_xy(float r, float angle, float *dx, float *dy)
{
	*dx = r*cos(angle*GLE_PI/180);
	*dy = r*sin(angle*GLE_PI/180);
}

void fxy_polar(float dx,float dy,float *radius,float *angle)
{
	if (dx==0 && dy==0) {
		gprint("Cannot work out angle of zero length vector\n");
		return;
	}
	if (dx==0) {
		*angle = 90;
		if (dy<0) *angle = -90;
	} else {
		*angle = myatan2(dy,dx)*180/GLE_PI;
	}
	*radius = sqrt(dx*dx+dy*dy);
}

void ncpy(char *d, char *s, int n)
{
	strncpy(d,s,n);
	*(d+n) = 0;
}

void ncat(char *d, char *s, int n)
{
	int i;
	i = strlen(d);
	strncat(d,s,n);
	*(d+i+n) = 0;
}

#ifdef VAXC
double myatan2(double y, double x)
{
	static double one,test,xx,yy,zero,at2;
	zero = 0;
	one = 1;
	xx = fabs(x);
	yy = fabs(y);
	if (x==0) {
		at2 = GLE_PI/2;
	} else {
		if (yy<=xx) {
			at2 = fabs(atan(yy/xx));
		} else {
			test = one + (xx/yy);
			if (test!=one) {
				at2 = fabs(atan(yy/xx));
			} else {
				at2 = GLE_PI/2;
			}
		}
		if (x<zero) at2 = GLE_PI - at2;
	}
	if (y<0) at2 = -at2;
	return at2;
}
#else
double myatan2(double y, double x)
{
	return atan2(y,x);
}
#endif


