
/*
 * Trying to add surface support back into GLE
 * Jan Struyf 2005
 */

#include "../all.h"
#include "../SourceLine.h"
#include "../tokens/Tokenizer.h"
#include "../core.h"
#include "../mygraph.h"
#include "../file_io.h"
#include "../texinterface.h"
#include "../cutils.h"
#include "../gprint.h"
#include "../cmdline.h"
#include "../config.h"
#include "../mem_limits.h"
#include "../token.h"
#include "../glearray.h"
#include "../polish.h"
#include "../var.h"
#include "../gprint.h"
#include "../run.h"

#define BEGINDEF extern
#include "../begin.h"

double get_next_exp(TOKENS tk, int ntk, int *curtok);
void get_next_exp_file(TOKENS tk, int ntok, int *curtok, string* res);

#define kw(ss) if (ct <= ntk && str_i_equals(tk[ct],ss))
#define next_file_eval(s) get_next_exp_file(tk,ntk,&ct,&s)
#define next_str(s) ct+=1;s=tk[ct]

void get_from_to_step(TOKENS tk, int ntok, int *curtok, double* from, double* to, double* step) throw(ParserError) {
	(*curtok) = (*curtok) + 1;
	if ((*curtok) >= ntok) {
		return;
	}
	if (!str_i_equals(tk[(*curtok)], "FROM")) {
		g_throw_parser_error("expecting 'from' in letz block");
	}
	*from = get_next_exp(tk, ntok, curtok);
	(*curtok) = (*curtok) + 1;
	if ((*curtok) >= ntok) {
		return;
	}
	if (!str_i_equals(tk[(*curtok)], "TO")) {
		g_throw_parser_error("expecting 'to' in letz block");
	}
	*to = get_next_exp(tk, ntok, curtok);
	(*curtok) = (*curtok) + 1;
	if ((*curtok) >= ntok) {
		return;
	}
	if (!str_i_equals(tk[(*curtok)], "STEP")) {
		g_throw_parser_error("expecting 'step' in letz block");
	}
	*step = get_next_exp(tk, ntok, curtok);
}

void begin_letz(int *pln, int *pcode, int *cp) throw(ParserError) {
	// Variables
	double xmin = 10, xmax = 10, xstep = 1;
	double ymin = 10, ymax = 10, ystep = 1;
	string equation, data_file;
	// Start with pcode from the next line
	(*pln)++;
	begin_init();
	while (true) {
		int st = begin_token(&pcode,cp,pln,srclin,tk,&ntk,outbuff);
		if (!st) {
			/* exit loop */
			break;
		}
		int ct = 1;
		kw("DATA") {
			next_file_eval(data_file);
		} else kw("Z") {
			ct++;
			next_str(equation);
		} else kw("X") {
			get_from_to_step(tk, ntk, &ct, &xmin, &xmax, &xstep);
		} else kw("Y") {
			get_from_to_step(tk, ntk, &ct, &ymin, &ymax, &ystep);
		} else if (ct <= ntk) {
			stringstream err;
			err << "illegal keyword in letz block: '" << tk[ct] << "'";
			g_throw_parser_error(err.str());
		}
	}
	// Create data file (if modified)
/*
	cout << "Wriging to: " << data_file << endl;
	cout << "Equation:   " << equation << endl;
	cout << "X from " << xmin << " to " << xmax << " step " << xstep << endl;
	cout << "Y from " << ymin << " to " << ymax << " step " << ystep << endl;
*/
	int xvar, yvar, vtype = 1;
	var_findadd("X", &xvar, &vtype);
	var_findadd("Y", &yvar, &vtype);
	token_space();
	/* Polish our equation */
	int evalcode[400], plen = 0;
	polish((char*)equation.c_str(),(char *)evalcode, &plen, &vtype);
	if (get_nb_errors()!=0) {
		return;
	}
	FILE* fp = fopen(data_file.c_str(),"wb");
	if (fp==NULL) {
		gprint("Unable to open {%s} \n",data_file.c_str());
		return;
	}
	char outstr[20];
	int nx = (int)((xmax-xmin)/xstep + 1);
	int ny = (int)((ymax-ymin)/ystep + 1);
	fprintf(fp,"! nx %d ny %d xmin %g xmax %g ymin %g ymax %g \n",nx,ny,xmin,xmax,ymin,ymax);
	for (double y=ymin, yi=0; yi<ny ; yi++, y+=ystep) {
		for (double x=xmin, xi=0; xi<nx; xi++, x+=xstep) {
			var_set(xvar, x);
			var_set(yvar, y);
			int mcp = 0;
			double value;
			eval(evalcode,&mcp,&value,outstr,&vtype);
			fprintf(fp,"%g ",value);
		}
		fprintf(fp,"\n");
	}
	fclose(fp);
}
