
#include <stdio.h>
#include <stdlib.h>

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

using namespace std;

#include "basicconf.h"
#include "cutils.h"
#include "file_io.h"
#include "tokens/stokenizer.h"

int main(int argc, char** argv) {
	string bin    = argv[1];
	string data   = argv[2];
	string config = argv[3];
	cout << "Binary:   \"" << bin << "\"" << endl;
	cout << "GLE_TOP:  \"" << data << "\"" << endl;
	char path = '/';
	#ifdef __WIN32__
		path = '\\';
	#endif
	char spliton[2];
	spliton[0] = path;
	spliton[1] = 0;
	string nxt1;
	string nxt2;
	char_separator separator(spliton, "");
	tokenizer<char_separator> tok1(bin, separator);
	tokenizer<char_separator> tok2(data, separator);
	bool more1 = tok1.has_more();
	bool more2 = tok2.has_more();
	while (more1 && more2) {
		nxt1 = tok1.next_token();
		nxt2 = tok2.next_token();
		if (!str_i_equals(nxt1, nxt2)) break;
		more1 = tok1.has_more();
		more2 = tok2.has_more();
	}
	string rpath;
	int nb_back = 0;
	if (str_i_equals(nxt1, nxt2)) {
		int pos = 0;
		while (tok2.has_more()) {
			if (pos != 0) rpath += spliton;
			rpath += tok2.next_token();
			pos++;
		}
	} else {
		rpath = nxt2;
		while (tok2.has_more()) {
			rpath += spliton;
			rpath += tok2.next_token();
		}
		if (more1) {
			nb_back++;
			while (tok1.has_more()) {
				tok1.next_token();
				nb_back++;
			}
		}
	}
	cout << "Relative: \"" << nb_back << "\"" << endl;
	cout << "Path:     \"" << rpath << "\"" << endl;
	vector<string> lines;
	ifstream ifile(config.c_str());
	if (!ifile.good()) {
		cout << "Can't open: '" << config << "'" << endl;
		return -1;
	}
	while (!ifile.eof()) {
		string line;
		ReadFileLine(ifile, line);
		if (str_i_str(line.c_str(), "[SETRELPATH]")) {
			break;
		}
		lines.push_back(line);
	}
	ifile.close();
	ofstream ofile(config.c_str());
	for (int i = 0; i < lines.size(); i++) {
		ofile << lines[i] << endl;
	}
	ofile << endl;
	ofile << "/* [SETRELPATH]: The following lines have been added by 'build/bin/setrelpath' */" << endl;
	ofile << "#define GLETOP_CD " << nb_back << endl;
	ofile << "#define GLETOP_REL \"" << rpath << "\"" << endl;
	ofile << endl;
	ofile.close();
	return 0;
}


