
#include "StringKeyHash.h"

#ifdef GLE_USE_HASHTABLE

int StringIntHash::try_get(const name_hash_key& key) const {
	StringBasicHash<int>::const_iterator i = find(key);
	if (i != end()) {
		return i->second;
	} else {
		return -1;
	}
}

void StringIntHash::add_item(const name_hash_key& key, int elem) {
	insert(StringKeyPair<int>(key, elem));
}

void* StringVoidPtrHash::try_get(const name_hash_key& key) const {
	StringBasicHash<void*>::const_iterator i = find(key);
	if (i != end()) {
		return i->second;
	} else {
		return NULL;
	}
}

void StringVoidPtrHash::add_item(const name_hash_key& key, void* elem) {
	insert(StringKeyPair<void*>(key, elem));
}

void StringVoidPtrHash::deleteRecursive(int depth) {
	if (depth <= 0) return;
	for (StringVoidPtrHash::iterator iter = begin(); iter != end(); iter++) {
		void* elem = iter->second;
		if (elem != NULL) {
			StringVoidPtrHash* hash = (StringVoidPtrHash*)elem;
			hash->deleteRecursive(depth - 1);
			delete hash;
		}
	}
}

#endif

int IntIntHash::try_get(int key) const {
	IntBasicHash<int>::const_iterator i = find(key);
	if (i != end()) {
		return i->second;
	} else {
		return -1;
	}
}

void IntIntHash::add_item(int key, int elem) {
	insert(IntKeyPair<int>(key, elem));
}

int IntStringHash::try_get(int key, string* res) const {
	IntBasicHash<string>::const_iterator i = find(key);
	if (i != end()) {
		*res = i->second;
		return 1;
	} else {
		return 0;
	}
}

void IntStringHash::add_item(int key, const string& elem) {
	insert(IntKeyPair<string>(key, elem));
}
