#ifndef INCLUDE_VAR
#define INCLUDE_VAR

#define GLE_VAR_LOCAL_BIT 0x10000000

#define GLE_VAR_IS_LOCAL(a) (a & GLE_VAR_LOCAL_BIT) != 0

class GLEVarMap;

class GLEVarSubMap {
protected:
	StringIntHash m_Map;
	vector<int> m_Idxs;
	GLEVarMap* m_Parent;
public:
	GLEVarSubMap(GLEVarMap* parent);
	~GLEVarSubMap();
	void clear();
	void removeFromParent();
	void var_add(const string& name, int idx);
	inline int var_get(const string& name) { return m_Map.try_get(name); }
	inline int size() { return m_Idxs.size(); }
	inline int get(int i) { return m_Idxs[i]; }
};

class GLEVarMap {
protected:
	vector<string> m_Names;
	vector<int> m_Types;
	StringIntHash m_Map;
	vector<int> m_Free;
	vector<GLEVarSubMap*> m_SubMap;
	bool m_IsTemp;
public:
	GLEVarMap();
	~GLEVarMap();
	int var_find_add(const string& name, bool* isnew);
	int var_find_add_submap(const string& name, bool* isnew);
	int var_get(const string& name);
	const string& var_name(int idx);
	void clear();
	void list();
	int getFreeID();
	int addVarIdx(const string& name);
	void removeVar(int idx);
	void clearSubMaps();
	GLEVarSubMap* pushSubMap();
	void popSubMap();
	inline int size() { return m_Names.size(); }
	inline int getType(int idx) { return m_Types[idx]; }
	inline void setType(int idx, int type) { m_Types[idx] = type; }
	inline bool hasSubMap() { return m_SubMap.size() > 0; }
	inline bool isTemp() { return m_IsTemp; }
	inline void setTemp(bool temp) { m_IsTemp = temp; }
};

class GLELocalVars {
public:
	vector<double> var_val;
	vector<string> var_str;
public:
	GLELocalVars(int num);
	~GLELocalVars();
	void expand(int num);
	void copyFrom(GLELocalVars* other);
	void copyFrom(GLELocalVars* other, int nb);
	GLELocalVars* clone(int nb);
	inline int size() { return var_val.size(); }
};

bool str_var(const string& s);
bool str_var(const char* s);
int valid_var(char *s);
bool has_local_var_map();
GLEVarMap* get_local_var_map();
void var_add_local(char *name, int *idx, int *type);
GLELocalVars* get_local_vars();
void var_alloc_local(int num);
void var_alloc_local(GLEVarMap* map);
bool var_check(int *j);
void var_clear_global(void);
void var_clear_local(void);
void var_def(char *s, double x);
void var_find(char *name,int *idx,int *type)	/* Find a variable in the list */;
void var_find_dn(GLEVarSubMap* map, int *idx, int *var, int *nd);
void var_findadd(char *name,int *idx,int *type)	/* Add a variable to the list */;
void var_free_local(void);
void var_get(int jj, double *v);
void var_getstr(int v, char *s);
void var_getstr(int jj, string& s);
void var_nlocal(int *l);
void var_set(int jj, double v);
GLEVarMap* var_swap_local_map(GLEVarMap* map);
void var_set_local_map(GLEVarMap* map);
void var_setstr(int jj, char *s);
char* var_get_name(int jj);
bool var_valid_name(const string& name);
void var_findadd_set(char* name, double value);
GLEVarSubMap* var_add_local_submap();
void var_remove_local_submap();

#endif
