/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.remoting.ssl;

import java.util.Objects;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;

public final class SSLContextConfig {
    private final String keystorePath;
    private final String keystoreType;
    private final String keystorePassword;
    private final String keystoreProvider;
    private final String truststorePath;
    private final String truststoreType;
    private final String truststorePassword;
    private final String truststoreProvider;
    private final String trustManagerFactoryPlugin;
    private final String crlPath;
    private final boolean trustAll;
    private final String keystoreAlias;
    private final int hashCode;

    public static Builder builder() {
        return new Builder();
    }

    private SSLContextConfig(String keystoreProvider, String keystorePath, String keystoreType, String keystorePassword, String truststoreProvider, String truststorePath, String truststoreType, String truststorePassword, String crlPath, String trustManagerFactoryPlugin, boolean trustAll, String keystoreAlias) {
        this.keystorePath = keystorePath;
        this.keystoreType = keystoreType;
        this.keystoreProvider = keystoreProvider;
        this.keystorePassword = keystorePassword;
        this.truststorePath = truststorePath;
        this.truststoreType = truststoreType;
        this.truststorePassword = truststorePassword;
        this.truststoreProvider = truststoreProvider;
        this.trustManagerFactoryPlugin = trustManagerFactoryPlugin;
        this.crlPath = crlPath;
        this.trustAll = trustAll;
        this.keystoreAlias = keystoreAlias;
        this.hashCode = Objects.hash(keystorePath, keystoreType, keystoreProvider, truststorePath, truststoreType, truststoreProvider, crlPath, trustManagerFactoryPlugin, trustAll, keystoreAlias);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SSLContextConfig)) {
            return false;
        }
        SSLContextConfig other = (SSLContextConfig)obj;
        return Objects.equals(this.keystorePath, other.keystorePath) && Objects.equals(this.keystoreType, other.keystoreType) && Objects.equals(this.keystoreProvider, other.keystoreProvider) && Objects.equals(this.truststorePath, other.truststorePath) && Objects.equals(this.truststoreType, other.truststoreType) && Objects.equals(this.truststoreProvider, other.truststoreProvider) && Objects.equals(this.crlPath, other.crlPath) && Objects.equals(this.trustManagerFactoryPlugin, other.trustManagerFactoryPlugin) && this.trustAll == other.trustAll && Objects.equals(this.keystoreAlias, other.keystoreAlias);
    }

    public String getCrlPath() {
        return this.crlPath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystoreProvider() {
        return this.keystoreProvider;
    }

    public String getTrustManagerFactoryPlugin() {
        return this.trustManagerFactoryPlugin;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public String getTruststoreProvider() {
        return this.truststoreProvider;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public String getKeystoreAlias() {
        return this.keystoreAlias;
    }

    public String toString() {
        return "SSLSupport [keystoreProvider=" + this.keystoreProvider + ", keystorePath=" + this.keystorePath + ", keystoreType=" + this.keystoreType + ", keystorePassword=" + (this.keystorePassword == null ? null : "******") + ", truststoreProvider=" + this.truststoreProvider + ", truststorePath=" + this.truststorePath + ", truststoreType=" + this.truststoreType + ", truststorePassword=" + (this.truststorePassword == null ? null : "******") + ", crlPath=" + this.crlPath + ", trustAll=" + this.trustAll + ", trustManagerFactoryPlugin=" + this.trustManagerFactoryPlugin + ", keystoreAlias=" + this.keystoreAlias + "]";
    }

    public static final class Builder {
        private String keystorePath = TransportConstants.DEFAULT_KEYSTORE_PATH;
        private String keystoreType = "JKS";
        private String keystorePassword = TransportConstants.DEFAULT_KEYSTORE_PASSWORD;
        private String keystoreProvider = TransportConstants.DEFAULT_KEYSTORE_PROVIDER;
        private String truststorePath = TransportConstants.DEFAULT_TRUSTSTORE_PATH;
        private String truststoreType = "JKS";
        private String truststorePassword = TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD;
        private String truststoreProvider = TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER;
        private String crlPath = TransportConstants.DEFAULT_CRL_PATH;
        private String trustManagerFactoryPlugin = TransportConstants.DEFAULT_TRUST_MANAGER_FACTORY_PLUGIN;
        private boolean trustAll = false;
        private String keystoreAlias = TransportConstants.DEFAULT_KEYSTORE_ALIAS;

        private Builder() {
        }

        public Builder from(SSLContextConfig config) {
            if (config == null) {
                return this;
            }
            this.keystorePath = config.getKeystorePath();
            this.keystoreType = config.getKeystoreType();
            this.keystorePassword = config.getKeystorePassword();
            this.keystoreProvider = config.getKeystoreProvider();
            this.truststorePath = config.getTruststorePath();
            this.truststoreType = config.getTruststoreType();
            this.truststorePassword = config.getTruststorePassword();
            this.crlPath = config.getCrlPath();
            this.truststoreProvider = config.getTruststoreProvider();
            this.trustAll = config.trustAll;
            this.keystoreAlias = config.keystoreAlias;
            return this;
        }

        public SSLContextConfig build() {
            return new SSLContextConfig(this.keystoreProvider, this.keystorePath, this.keystoreType, this.keystorePassword, this.truststoreProvider, this.truststorePath, this.truststoreType, this.truststorePassword, this.crlPath, this.trustManagerFactoryPlugin, this.trustAll, this.keystoreAlias);
        }

        public Builder keystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        public Builder keystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
            return this;
        }

        public Builder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public Builder keystoreProvider(String keystoreProvider) {
            this.keystoreProvider = keystoreProvider;
            return this;
        }

        public Builder truststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
            return this;
        }

        public Builder truststoreType(String truststoreType) {
            this.truststoreType = truststoreType;
            return this;
        }

        public Builder truststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
            return this;
        }

        public Builder truststoreProvider(String truststoreProvider) {
            this.truststoreProvider = truststoreProvider;
            return this;
        }

        public Builder crlPath(String crlPath) {
            this.crlPath = crlPath;
            return this;
        }

        public Builder trustAll(boolean trustAll) {
            this.trustAll = trustAll;
            return this;
        }

        public Builder keystoreAlias(String keystoreAlias) {
            this.keystoreAlias = keystoreAlias;
            return this;
        }

        public Builder trustManagerFactoryPlugin(String trustManagerFactoryPlugin) {
            this.trustManagerFactoryPlugin = trustManagerFactoryPlugin;
            return this;
        }
    }
}

