/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;

public class BootstrapMethod
implements Cloneable {
    private int bootstrap_method_ref;
    private int[] bootstrap_arguments;

    public BootstrapMethod(BootstrapMethod c) {
        this(c.getBootstrapMethodRef(), c.getBootstrapArguments());
    }

    BootstrapMethod(DataInput input) throws IOException {
        this(input.readUnsignedShort(), input.readUnsignedShort());
        for (int i = 0; i < this.bootstrap_arguments.length; ++i) {
            this.bootstrap_arguments[i] = input.readUnsignedShort();
        }
    }

    private BootstrapMethod(int bootstrap_method_ref, int num_bootstrap_arguments) {
        this(bootstrap_method_ref, new int[num_bootstrap_arguments]);
    }

    public BootstrapMethod(int bootstrap_method_ref, int[] bootstrap_arguments) {
        this.bootstrap_method_ref = bootstrap_method_ref;
        this.bootstrap_arguments = bootstrap_arguments;
    }

    public int getBootstrapMethodRef() {
        return this.bootstrap_method_ref;
    }

    public void setBootstrapMethodRef(int bootstrap_method_ref) {
        this.bootstrap_method_ref = bootstrap_method_ref;
    }

    public int[] getBootstrapArguments() {
        return this.bootstrap_arguments;
    }

    public int getNumBootstrapArguments() {
        return this.bootstrap_arguments.length;
    }

    public void setBootstrapArguments(int[] bootstrap_arguments) {
        this.bootstrap_arguments = bootstrap_arguments;
    }

    public final String toString() {
        return "BootstrapMethod(" + this.bootstrap_method_ref + ", " + this.bootstrap_arguments.length + ", " + Arrays.toString(this.bootstrap_arguments) + ")";
    }

    public final String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String bootstrap_method_name = constant_pool.constantToString(this.bootstrap_method_ref, (byte)15);
        buf.append(Utility.compactClassName(bootstrap_method_name, false));
        int num_bootstrap_arguments = this.bootstrap_arguments.length;
        if (num_bootstrap_arguments > 0) {
            buf.append("\nMethod Arguments:");
            for (int i = 0; i < num_bootstrap_arguments; ++i) {
                buf.append("\n  ").append(i).append(": ");
                buf.append(constant_pool.constantToString(constant_pool.getConstant(this.bootstrap_arguments[i])));
            }
        }
        return buf.toString();
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.bootstrap_method_ref);
        file.writeShort(this.bootstrap_arguments.length);
        for (int bootstrap_argument : this.bootstrap_arguments) {
            file.writeShort(bootstrap_argument);
        }
    }

    public BootstrapMethod copy() {
        try {
            return (BootstrapMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

