/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class EncryptionToken
extends AbstractSecurityAssertion
implements TokenWrapper {
    private Token encryptionToken;

    public EncryptionToken(int version) {
        this.setVersion(version);
    }

    public Token getEncryptionToken() {
        return this.encryptionToken;
    }

    public void setEncryptionToken(Token encryptionToken) {
        this.encryptionToken = encryptionToken;
    }

    @Override
    public void setToken(Token tok) {
        this.setEncryptionToken(tok);
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.ENCRYPTION_TOKEN;
        }
        return SP11Constants.ENCRYPTION_TOKEN;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        EncryptionToken.writeStartElement(writer, this.getName());
        EncryptionToken.writeStartElement(writer, SPConstants.POLICY);
        if (this.encryptionToken == null) {
            throw new RuntimeException("EncryptionToken is not set");
        }
        this.encryptionToken.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

