/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformstatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationplatformstatus.traits.Mount;
import org.apache.camel.v1.integrationplatformstatus.traits.mount.Configuration;
import org.apache.camel.v1.integrationplatformstatus.traits.mount.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformstatus.traits.mount.ConfigurationFluent;

public class MountFluent<A extends MountFluent<A>>
extends BaseFluent<A> {
    private List<String> configs;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Boolean hotReload;
    private List<String> resources;
    private Boolean scanKameletsImplicitLabelSecrets;
    private List<String> volumes;

    public MountFluent() {
    }

    public MountFluent(Mount instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Mount instance) {
        Mount mount = instance = instance != null ? instance : new Mount();
        if (instance != null) {
            this.withConfigs(instance.getConfigs());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withHotReload(instance.getHotReload());
            this.withResources(instance.getResources());
            this.withScanKameletsImplicitLabelSecrets(instance.getScanKameletsImplicitLabelSecrets());
            this.withVolumes(instance.getVolumes());
        }
    }

    public A addToConfigs(int index, String item) {
        if (this.configs == null) {
            this.configs = new ArrayList<String>();
        }
        this.configs.add(index, item);
        return (A)((Object)this);
    }

    public A setToConfigs(int index, String item) {
        if (this.configs == null) {
            this.configs = new ArrayList<String>();
        }
        this.configs.set(index, item);
        return (A)((Object)this);
    }

    public A addToConfigs(String ... items) {
        if (this.configs == null) {
            this.configs = new ArrayList<String>();
        }
        for (String item : items) {
            this.configs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConfigs(Collection<String> items) {
        if (this.configs == null) {
            this.configs = new ArrayList<String>();
        }
        for (String item : items) {
            this.configs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConfigs(String ... items) {
        if (this.configs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.configs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfigs(Collection<String> items) {
        if (this.configs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.configs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getConfigs() {
        return this.configs;
    }

    public String getConfig(int index) {
        return this.configs.get(index);
    }

    public String getFirstConfig() {
        return this.configs.get(0);
    }

    public String getLastConfig() {
        return this.configs.get(this.configs.size() - 1);
    }

    public String getMatchingConfig(Predicate<String> predicate) {
        for (String item : this.configs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConfig(Predicate<String> predicate) {
        for (String item : this.configs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfigs(List<String> configs) {
        if (configs != null) {
            this.configs = new ArrayList<String>();
            for (String item : configs) {
                this.addToConfigs(item);
            }
        } else {
            this.configs = null;
        }
        return (A)((Object)this);
    }

    public A withConfigs(String ... configs) {
        if (this.configs != null) {
            this.configs.clear();
            this._visitables.remove((Object)"configs");
        }
        if (configs != null) {
            for (String item : configs) {
                this.addToConfigs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConfigs() {
        return this.configs != null && !this.configs.isEmpty();
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getHotReload() {
        return this.hotReload;
    }

    public A withHotReload(Boolean hotReload) {
        this.hotReload = hotReload;
        return (A)((Object)this);
    }

    public boolean hasHotReload() {
        return this.hotReload != null;
    }

    public A addToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)((Object)this);
    }

    public A setToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.set(index, item);
        return (A)((Object)this);
    }

    public A addToResources(String ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResources(String ... items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResources(Collection<String> items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getResource(int index) {
        return this.resources.get(index);
    }

    public String getFirstResource() {
        return this.resources.get(0);
    }

    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<String> resources) {
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)((Object)this);
    }

    public A withResources(String ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public Boolean getScanKameletsImplicitLabelSecrets() {
        return this.scanKameletsImplicitLabelSecrets;
    }

    public A withScanKameletsImplicitLabelSecrets(Boolean scanKameletsImplicitLabelSecrets) {
        this.scanKameletsImplicitLabelSecrets = scanKameletsImplicitLabelSecrets;
        return (A)((Object)this);
    }

    public boolean hasScanKameletsImplicitLabelSecrets() {
        return this.scanKameletsImplicitLabelSecrets != null;
    }

    public A addToVolumes(int index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.add(index, item);
        return (A)((Object)this);
    }

    public A setToVolumes(int index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.set(index, item);
        return (A)((Object)this);
    }

    public A addToVolumes(String ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<String> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(String ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<String> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public String getVolume(int index) {
        return this.volumes.get(index);
    }

    public String getFirstVolume() {
        return this.volumes.get(0);
    }

    public String getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    public String getMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<String> volumes) {
        if (volumes != null) {
            this.volumes = new ArrayList<String>();
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(String ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MountFluent that = (MountFluent)((Object)o);
        if (!Objects.equals(this.configs, that.configs)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.hotReload, that.hotReload)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.scanKameletsImplicitLabelSecrets, that.scanKameletsImplicitLabelSecrets)) {
            return false;
        }
        return Objects.equals(this.volumes, that.volumes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configs, this.configuration, this.enabled, this.hotReload, this.resources, this.scanKameletsImplicitLabelSecrets, this.volumes, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configs != null && !this.configs.isEmpty()) {
            sb.append("configs:");
            sb.append(this.configs + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.hotReload != null) {
            sb.append("hotReload:");
            sb.append(this.hotReload + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.scanKameletsImplicitLabelSecrets != null) {
            sb.append("scanKameletsImplicitLabelSecrets:");
            sb.append(this.scanKameletsImplicitLabelSecrets + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withHotReload() {
        return this.withHotReload(true);
    }

    public A withScanKameletsImplicitLabelSecrets() {
        return this.withScanKameletsImplicitLabelSecrets(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)MountFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

