/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DIGraph;

class ListProvider<T>
implements Provider<List<T>> {
    private Map<Key<? extends T>, Provider<? extends T>> providers = new HashMap<Key<? extends T>, Provider<? extends T>>();
    private DIGraph<Key<? extends T>> graph = new DIGraph();

    @Override
    public List<T> get() throws DIRuntimeException {
        List<Key<T>> insertOrder = this.graph.topSort();
        if (insertOrder.size() != this.providers.size()) {
            ArrayList<Key<? extends T>> emptyKeys = new ArrayList<Key<? extends T>>();
            for (Key<? extends T> key : insertOrder) {
                if (this.providers.containsKey(key)) continue;
                emptyKeys.add(key);
            }
            throw new DIRuntimeException("DI list has no providers for keys: %s", emptyKeys);
        }
        ArrayList<T> list = new ArrayList<T>(insertOrder.size());
        for (Key<? extends T> key : insertOrder) {
            list.add(this.providers.get(key).get());
        }
        return list;
    }

    void add(Key<? extends T> key, Provider<? extends T> provider) {
        this.providers.put(key, provider);
        this.graph.add(key);
    }

    void addAfter(Key<? extends T> key, Provider<? extends T> provider, Key<? extends T> after) {
        this.providers.put(key, provider);
        this.graph.add(key, after);
    }

    void insertBefore(Key<? extends T> key, Provider<? extends T> provider, Key<? extends T> before) {
        this.providers.put(key, provider);
        this.graph.add(before, key);
    }

    void addAll(Map<Key<? extends T>, Provider<? extends T>> keyProviderMap) {
        this.providers.putAll(keyProviderMap);
        this.graph.addAll(keyProviderMap.keySet());
    }

    void addAllAfter(Map<Key<? extends T>, Provider<? extends T>> keyProviderMap, Key<? extends T> after) {
        this.providers.putAll(keyProviderMap);
        for (Key<T> key : keyProviderMap.keySet()) {
            this.graph.add(key, after);
        }
    }

    void insertAllBefore(Map<Key<? extends T>, Provider<? extends T>> keyProviderMap, Key<? extends T> before) {
        this.providers.putAll(keyProviderMap);
        for (Key<T> key : keyProviderMap.keySet()) {
            this.graph.add(before, key);
        }
    }
}

