/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.ObjEntityCounterpartAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.dialog.objentity.ClassNameUpdater;
import org.apache.cayenne.modeler.dialog.validator.DuplicatedAttributesDialog;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.graph.action.ShowGraphEntityAction;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.ExpressionConvertor;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.swing.components.JCayenneCheckBox;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class ObjEntityTab
extends JPanel
implements ObjEntityDisplayListener,
ExistingSelectionProcessor {
    private static final ObjEntity NO_INHERITANCE = new ObjEntity("Direct Mapping to Table/View");
    protected ProjectController mediator;
    protected TextAdapter name;
    protected TextAdapter className;
    protected JLabel superclassLabel;
    protected TextAdapter superClassName;
    protected TextAdapter qualifier;
    protected JComboBox<DbEntity> dbEntityCombo;
    protected JComboBox<ObjEntity> superEntityCombo;
    protected JButton tableLabel;
    protected JCheckBox readOnly;
    protected JCheckBox optimisticLocking;
    protected JComponent clientSeparator;
    protected JLabel isAbstractLabel;
    protected JLabel serverOnlyLabel;
    protected JLabel clientClassNameLabel;
    protected JLabel clientSuperClassNameLabel;
    protected JCheckBox serverOnly;
    protected JCheckBox isAbstract;
    protected TextAdapter comment;
    protected TextAdapter clientClassName;
    protected TextAdapter clientSuperClassName;

    public ObjEntityTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(BorderFactory.createEmptyBorder());
        toolBar.setFloatable(false);
        ActionManager actionManager = Application.getInstance().getActionManager();
        toolBar.add(actionManager.getAction(CreateAttributeAction.class).buildButton(1));
        toolBar.add(actionManager.getAction(CreateRelationshipAction.class).buildButton(3));
        toolBar.addSeparator();
        toolBar.add(actionManager.getAction(ObjEntitySyncAction.class).buildButton(1));
        toolBar.add(actionManager.getAction(ObjEntityCounterpartAction.class).buildButton(3));
        toolBar.addSeparator();
        toolBar.add(actionManager.getAction(ShowGraphEntityAction.class).buildButton());
        this.add((Component)toolBar, "North");
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ObjEntityTab.this.setEntityName(text);
            }
        };
        this.superClassName = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ObjEntityTab.this.setSuperClassName(text);
            }
        };
        this.className = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ObjEntityTab.this.setClassName(text);
            }
        };
        this.qualifier = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ObjEntityTab.this.setQualifier(text);
            }
        };
        this.dbEntityCombo = Application.getWidgetFactory().createComboBox();
        this.superEntityCombo = Application.getWidgetFactory().createComboBox();
        AutoCompletion.enable(this.dbEntityCombo);
        AutoCompletion.enable(this.superEntityCombo);
        this.readOnly = new JCayenneCheckBox();
        this.optimisticLocking = new JCayenneCheckBox();
        this.tableLabel = new JButton("Table/View:");
        this.tableLabel.setBorderPainted(false);
        this.tableLabel.setHorizontalAlignment(2);
        this.tableLabel.setFocusPainted(false);
        this.tableLabel.setMargin(new Insets(0, 0, 0, 0));
        this.tableLabel.setBorder(null);
        this.isAbstract = new JCayenneCheckBox();
        this.serverOnly = new JCayenneCheckBox();
        this.comment = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) throws ValidationException {
                ObjEntityTab.this.setComment(text);
            }
        };
        this.clientClassName = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ObjEntityTab.this.setClientClassName(text);
            }
        };
        this.clientSuperClassName = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                ObjEntityTab.this.setClientSuperClassName(text);
            }
        };
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:200dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("ObjEntity Configuration");
        builder.append("ObjEntity Name:", (Component)this.name.getComponent());
        builder.append("Inheritance:", this.superEntityCombo);
        builder.append((Component)this.tableLabel, this.dbEntityCombo);
        this.isAbstractLabel = builder.append("Abstract class:", (Component)this.isAbstract);
        builder.append("Comment:", (Component)this.comment.getComponent());
        builder.appendSeparator();
        builder.append("Java Class:", (Component)this.className.getComponent());
        this.superclassLabel = builder.append("Superclass:", (Component)this.superClassName.getComponent());
        builder.append("Qualifier:", (Component)this.qualifier.getComponent());
        builder.append("Read-Only:", (Component)this.readOnly);
        builder.append("Optimistic Locking:", (Component)this.optimisticLocking);
        this.clientSeparator = builder.appendSeparator("Java Client");
        this.serverOnlyLabel = builder.append("Not for Client Use:", (Component)this.serverOnly);
        this.clientClassNameLabel = builder.append("Client Java Class:", (Component)this.clientClassName.getComponent());
        this.clientSuperClassNameLabel = builder.append("Client Superclass:", (Component)this.clientSuperClassName.getComponent());
        this.add((Component)builder.getPanel(), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.dbEntityCombo.addActionListener(e -> {
            ObjEntity entity = this.mediator.getCurrentObjEntity();
            DbEntity dbEntity = (DbEntity)this.dbEntityCombo.getSelectedItem();
            if (dbEntity != entity.getDbEntity()) {
                entity.setDbEntity(dbEntity);
                this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
            }
        });
        this.superEntityCombo.addActionListener(e -> {
            ObjEntity entity;
            ObjEntity superEntity = (ObjEntity)this.superEntityCombo.getSelectedItem();
            String name = superEntity == null || superEntity == NO_INHERITANCE ? null : superEntity.getName();
            if (!Util.nullSafeEquals(name, (entity = this.mediator.getCurrentObjEntity()).getSuperEntityName())) {
                List<ObjAttribute> duplicateAttributes = null;
                if (name != null) {
                    duplicateAttributes = this.getDuplicatedAttributes(superEntity);
                }
                if (duplicateAttributes != null && duplicateAttributes.size() > 0) {
                    DuplicatedAttributesDialog.showDialog(Application.getFrame(), duplicateAttributes, superEntity, entity);
                    if (DuplicatedAttributesDialog.getResult().equals("cancel")) {
                        this.superEntityCombo.setSelectedItem(entity.getSuperEntity());
                        this.superClassName.setText(entity.getSuperClassName());
                        return;
                    }
                }
                entity.setSuperEntityName(name);
                if (name == null) {
                    for (ObjAttribute objAttribute : entity.getAttributes()) {
                        if (objAttribute.getDbAttribute() != null) continue;
                        objAttribute.setDbAttributePath(null);
                    }
                }
                if (name == null) {
                    this.dbEntityCombo.setEnabled(true);
                } else {
                    this.dbEntityCombo.setEnabled(false);
                    this.dbEntityCombo.getModel().setSelectedItem(null);
                }
                this.toggleEnabled(name == null, !this.serverOnly.isSelected());
                this.dbEntityCombo.getModel().setSelectedItem(entity.getDbEntity());
                this.superClassName.setText(entity.getSuperClassName());
                DataChannelDescriptor domain = (DataChannelDescriptor)this.mediator.getProject().getRootNode();
                DataMap map = this.mediator.getCurrentDataMap();
                this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                this.mediator.fireObjEntityDisplayEvent(new EntityDisplayEvent((Object)this, entity, map, domain));
            }
        });
        this.tableLabel.addActionListener(e -> {
            DbEntity entity = this.mediator.getCurrentObjEntity().getDbEntity();
            if (entity != null) {
                DataChannelDescriptor dom = (DataChannelDescriptor)this.mediator.getProject().getRootNode();
                this.mediator.fireDbEntityDisplayEvent(new EntityDisplayEvent((Object)this, entity, entity.getDataMap(), dom));
            }
        });
        this.readOnly.addItemListener(e -> {
            ObjEntity entity = this.mediator.getCurrentObjEntity();
            if (entity != null) {
                entity.setReadOnly(this.readOnly.isSelected());
                this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
            }
        });
        this.optimisticLocking.addItemListener(e -> {
            ObjEntity entity = this.mediator.getCurrentObjEntity();
            if (entity != null) {
                entity.setDeclaredLockType(this.optimisticLocking.isSelected() ? 1 : 0);
                this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
            }
        });
        this.serverOnly.addItemListener(e -> {
            ObjEntity entity = this.mediator.getCurrentObjEntity();
            if (entity != null) {
                entity.setServerOnly(this.serverOnly.isSelected());
                this.toggleEnabled(this.dbEntityCombo.isEnabled(), !this.serverOnly.isSelected());
                this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
            }
        });
        this.isAbstract.addItemListener(e -> {
            ObjEntity entity = this.mediator.getCurrentObjEntity();
            if (entity != null) {
                entity.setAbstract(this.isAbstract.isSelected());
                this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
            }
        });
    }

    private void initFromModel(ObjEntity entity) {
        this.qualifier.getComponent().setBackground(Color.WHITE);
        this.name.setText(entity.getName());
        this.superClassName.setText(entity.getSuperClassName());
        this.className.setText(entity.getClassName());
        this.readOnly.setSelected(entity.isReadOnly());
        this.isAbstract.setSelected(entity.isAbstract());
        this.comment.setText(this.getComment(entity));
        this.serverOnly.setSelected(entity.isServerOnly());
        this.clientClassName.setText(entity.getClientClassName());
        this.clientSuperClassName.setText(entity.getClientSuperClassName());
        this.qualifier.setText(new ExpressionConvertor().valueAsString(entity.getDeclaredQualifier()));
        this.optimisticLocking.setSelected(entity.getDeclaredLockType() == 1);
        EntityResolver resolver = this.mediator.getEntityResolver();
        DataMap map = this.mediator.getCurrentDataMap();
        DbEntity[] dbEntities = resolver.getDbEntities().toArray(new DbEntity[0]);
        Arrays.sort(dbEntities, Comparators.getDataMapChildrenComparator());
        DefaultComboBoxModel<DbEntity> dbModel = new DefaultComboBoxModel<DbEntity>(dbEntities);
        dbModel.setSelectedItem(entity.getDbEntity());
        this.dbEntityCombo.setRenderer(CellRenderers.entityListRendererWithIcons(map));
        this.dbEntityCombo.setModel(dbModel);
        boolean isUsedInheritance = entity.getSuperEntity() != null;
        this.dbEntityCombo.setEnabled(!isUsedInheritance);
        this.toggleClientFieldsVisible(map.isClientSupported());
        this.toggleEnabled(entity.getSuperEntityName() == null, !entity.isServerOnly());
        List<ObjEntity> objEntities = map.getObjEntities().stream().filter(object -> entity != object && !object.isSubentityOf(entity)).sorted(Comparators.getDataMapChildrenComparator()).collect(Collectors.toList());
        objEntities.add(0, NO_INHERITANCE);
        DefaultComboBoxModel<ObjEntity> superEntityModel = new DefaultComboBoxModel<ObjEntity>(objEntities.toArray(new ObjEntity[0]));
        superEntityModel.setSelectedItem(entity.getSuperEntity());
        this.superEntityCombo.setRenderer(CellRenderers.entityListRendererWithIcons(map));
        this.superEntityCombo.setModel(superEntityModel);
    }

    void setClassName(String className) {
        ObjEntity entity;
        if (className != null && className.trim().length() == 0) {
            className = null;
        }
        if ((entity = this.mediator.getCurrentObjEntity()) != null && !Util.nullSafeEquals(entity.getClassName(), className)) {
            entity.setClassName(className);
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
        }
    }

    void setSuperClassName(String text) {
        ObjEntity ent;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((ent = this.mediator.getCurrentObjEntity()) != null && !Util.nullSafeEquals(ent.getSuperClassName(), text)) {
            ent.setSuperClassName(text);
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, ent));
        }
    }

    void setClientClassName(String className) {
        ObjEntity entity;
        if (className != null && className.trim().length() == 0) {
            className = null;
        }
        if ((entity = this.mediator.getCurrentObjEntity()) != null && !Util.nullSafeEquals(entity.getClientClassName(), className)) {
            entity.setClientClassName(className);
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
        }
    }

    void setClientSuperClassName(String text) {
        ObjEntity ent;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((ent = this.mediator.getCurrentObjEntity()) != null && !Util.nullSafeEquals(ent.getClientSuperClassName(), text)) {
            ent.setClientSuperClassName(text);
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, ent));
        }
    }

    void setQualifier(String text) {
        ObjEntity entity;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((entity = this.mediator.getCurrentObjEntity()) != null) {
            ExpressionConvertor convertor = new ExpressionConvertor();
            try {
                String oldQualifier = convertor.valueAsString(entity.getDeclaredQualifier());
                if (!Util.nullSafeEquals(oldQualifier, text)) {
                    Expression exp = (Expression)convertor.stringAsValue(text);
                    entity.setDeclaredQualifier(exp);
                    this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                }
            }
            catch (IllegalArgumentException ex) {
                throw new ValidationException(ex.getMessage(), new Object[0]);
            }
        }
    }

    void setEntityName(String newName) {
        ObjEntity entity;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((entity = this.mediator.getCurrentObjEntity()) == null) {
            return;
        }
        if (Util.nullSafeEquals(newName, entity.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Entity name is required.", new Object[0]);
        }
        if (entity.getDataMap().getObjEntity(newName) == null) {
            EntityEvent e = new EntityEvent((Object)this, (Entity)entity, entity.getName());
            entity.setName(newName);
            this.mediator.fireObjEntityEvent(e);
            ClassNameUpdater nameUpdater = new ClassNameUpdater(Application.getInstance().getFrameController(), entity);
            if (nameUpdater.doNameUpdate()) {
                this.className.setText(entity.getClassName());
                this.clientClassName.setText(entity.getClientClassName());
            }
        } else {
            throw new ValidationException("There is another entity with name '" + newName + "'.", new Object[0]);
        }
    }

    void toggleClientFieldsVisible(boolean visible) {
        this.clientSeparator.setVisible(visible);
        this.clientSuperClassNameLabel.setVisible(visible);
        this.clientClassNameLabel.setVisible(visible);
        this.serverOnlyLabel.setVisible(visible);
        this.clientClassName.getComponent().setVisible(visible);
        this.clientSuperClassName.getComponent().setVisible(visible);
        this.serverOnly.setVisible(visible);
    }

    void toggleEnabled(boolean directTableMapping, boolean clientFieldsEnabled) {
        this.superClassName.getComponent().setEnabled(directTableMapping);
        this.superclassLabel.setEnabled(directTableMapping);
        this.clientSuperClassName.getComponent().setEnabled(directTableMapping && clientFieldsEnabled);
        this.clientSuperClassNameLabel.setEnabled(directTableMapping && clientFieldsEnabled);
        this.clientClassNameLabel.setEnabled(clientFieldsEnabled);
        this.clientClassName.getComponent().setEnabled(clientFieldsEnabled);
    }

    @Override
    public void processExistingSelection(EventObject e) {
        EntityDisplayEvent ede = new EntityDisplayEvent((Object)this, this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode());
        this.mediator.fireObjEntityDisplayEvent(ede);
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity == null || !e.isEntityChanged()) {
            return;
        }
        this.initFromModel(entity);
    }

    private List<ObjAttribute> getDuplicatedAttributes(ObjEntity superEntity) {
        LinkedList<ObjAttribute> result = new LinkedList<ObjAttribute>();
        ObjEntity entity = this.mediator.getCurrentObjEntity();
        for (ObjAttribute attribute : entity.getAttributes()) {
            if (superEntity.getAttribute(attribute.getName()) == null) continue;
            result.add(attribute);
        }
        return result;
    }

    private void setComment(String value) {
        ObjEntity entity = this.mediator.getCurrentObjEntity();
        if (entity == null) {
            return;
        }
        ObjectInfo.putToMetaData(this.mediator.getApplication().getMetaData(), entity, "comment", value);
        this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
    }

    private String getComment(ObjEntity entity) {
        return ObjectInfo.getFromMetaData(this.mediator.getApplication().getMetaData(), entity, "comment");
    }
}

