/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class Logging
extends Log4JLogger {
    private static final String FQCN = Logging.class.getName();
    private static Priority traceLevel;

    public Logging() {
    }

    public Logging(String name) {
        super(name);
    }

    public Logging(Logger logger) {
        super(logger);
    }

    public void trace(Object message) {
        this.getLogger().log(FQCN, traceLevel, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.getLogger().log(FQCN, traceLevel, message, t);
    }

    public void debug(Object message) {
        this.getLogger().log(FQCN, Priority.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.getLogger().log(FQCN, Priority.DEBUG, message, t);
    }

    public void info(Object message) {
        this.getLogger().log(FQCN, Priority.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.getLogger().log(FQCN, Priority.INFO, message, t);
    }

    public void warn(Object message) {
        this.getLogger().log(FQCN, Priority.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.getLogger().log(FQCN, Priority.WARN, message, t);
    }

    public void error(Object message) {
        this.getLogger().log(FQCN, Priority.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.getLogger().log(FQCN, Priority.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.getLogger().log(FQCN, Priority.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.getLogger().log(FQCN, Priority.FATAL, message, t);
    }

    static {
        try {
            traceLevel = (Priority)Level.class.getDeclaredField("TRACE").get(null);
        }
        catch (Exception ex) {
            traceLevel = Priority.DEBUG;
        }
        String level = System.getProperty("LogLevel");
        if (level != null) {
            Logger log = Logger.getRootLogger();
            log.setLevel(Level.toLevel((String)level));
            ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout("%p %l - %m%n"), "System.out");
            log.addAppender((Appender)appender);
        }
    }
}

