/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.NoSuchElementException;
import org.apache.commons.configuration.ConfigurationKey;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationKey {
    private static final String TESTPROPS = "tables.table(0).fields.field(1)";
    private static final String TESTATTR = "[@dataType]";
    private static final String TESTKEY = "tables.table(0).fields.field(1)[@dataType]";

    @Test
    public void testAppend() {
        ConfigurationKey key = new ConfigurationKey();
        key.append("tables").append("table.").appendIndex(0);
        key.append("fields.").append("field").appendIndex(1);
        key.appendAttribute("dataType");
        Assert.assertEquals((Object)TESTKEY, (Object)key.toString());
    }

    @Test
    public void testIterate() {
        ConfigurationKey key = new ConfigurationKey(TESTKEY);
        ConfigurationKey.KeyIterator it = key.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"tables", (Object)it.nextKey());
        Assert.assertEquals((Object)"table", (Object)it.nextKey());
        Assert.assertTrue((boolean)it.hasIndex());
        Assert.assertEquals((long)0L, (long)it.getIndex());
        Assert.assertEquals((Object)"fields", (Object)it.nextKey());
        Assert.assertFalse((boolean)it.hasIndex());
        Assert.assertEquals((Object)"field", (Object)it.nextKey(true));
        Assert.assertEquals((long)1L, (long)it.getIndex());
        Assert.assertFalse((boolean)it.isAttribute());
        Assert.assertEquals((Object)"field", (Object)it.currentKey(true));
        Assert.assertEquals((Object)"dataType", (Object)it.nextKey());
        Assert.assertEquals((Object)TESTATTR, (Object)it.currentKey(true));
        Assert.assertTrue((boolean)it.isAttribute());
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assert.fail((String)"Could iterate over the iteration's end!");
        }
        catch (NoSuchElementException nex) {
            // empty catch block
        }
        key = new ConfigurationKey();
        Assert.assertFalse((boolean)key.iterator().hasNext());
        key.append("simple");
        it = key.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"simple", (Object)it.next());
        try {
            it.remove();
            Assert.fail((String)"Could remove key component!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testAttribute() {
        Assert.assertTrue((boolean)ConfigurationKey.isAttributeKey((String)TESTATTR));
        Assert.assertFalse((boolean)ConfigurationKey.isAttributeKey((String)TESTPROPS));
        Assert.assertFalse((boolean)ConfigurationKey.isAttributeKey((String)TESTKEY));
        ConfigurationKey key = new ConfigurationKey(TESTPROPS);
        key.append(TESTATTR);
        Assert.assertEquals((Object)TESTKEY, (Object)key.toString());
    }

    @Test
    public void testLength() {
        ConfigurationKey key = new ConfigurationKey(TESTPROPS);
        Assert.assertEquals((long)TESTPROPS.length(), (long)key.length());
        key.appendAttribute("dataType");
        Assert.assertEquals((long)TESTKEY.length(), (long)key.length());
        key.setLength(TESTPROPS.length());
        Assert.assertEquals((long)TESTPROPS.length(), (long)key.length());
        Assert.assertEquals((Object)TESTPROPS, (Object)key.toString());
    }

    @Test
    public void testConstructAttributeKey() {
        Assert.assertEquals((Object)"[@attribute]", (Object)ConfigurationKey.constructAttributeKey((String)"attribute"));
        Assert.assertEquals((Object)"attribute", (Object)ConfigurationKey.attributeName((String)"[@attribute]"));
        Assert.assertEquals((Object)"attribute", (Object)ConfigurationKey.attributeName((String)"attribute"));
    }

    @Test
    public void testEquals() {
        ConfigurationKey k1 = new ConfigurationKey(TESTKEY);
        ConfigurationKey k2 = new ConfigurationKey(TESTKEY);
        Assert.assertTrue((boolean)k1.equals((Object)k2));
        Assert.assertTrue((boolean)k2.equals((Object)k1));
        Assert.assertEquals((long)k1.hashCode(), (long)k2.hashCode());
        k2.append("anotherPart");
        Assert.assertFalse((boolean)k1.equals((Object)k2));
        Assert.assertFalse((boolean)k2.equals((Object)k1));
        Assert.assertFalse((boolean)k1.equals(null));
        Assert.assertTrue((boolean)k1.equals((Object)TESTKEY));
    }

    @Test
    public void testCommonKey() {
        ConfigurationKey k1 = new ConfigurationKey(TESTKEY);
        ConfigurationKey k2 = new ConfigurationKey("tables.table(0).name");
        ConfigurationKey kc = k1.commonKey(k2);
        Assert.assertEquals((Object)new ConfigurationKey("tables.table(0)"), (Object)kc);
        Assert.assertEquals((Object)kc, (Object)k2.commonKey(k1));
        k2 = new ConfigurationKey("tables.table(1).fields.field(1)");
        kc = k1.commonKey(k2);
        Assert.assertEquals((Object)new ConfigurationKey("tables"), (Object)kc);
        k2 = new ConfigurationKey("completely.different.key");
        kc = k1.commonKey(k2);
        Assert.assertEquals((long)0L, (long)kc.length());
        k2 = new ConfigurationKey();
        kc = k1.commonKey(k2);
        Assert.assertEquals((long)0L, (long)kc.length());
        kc = k1.commonKey(k1);
        Assert.assertEquals((Object)kc, (Object)k1);
        try {
            kc.commonKey(null);
            Assert.fail((String)"Could construct common key with null key!");
        }
        catch (IllegalArgumentException iex) {
            // empty catch block
        }
    }

    @Test
    public void testDifferenceKey() {
        ConfigurationKey k1 = new ConfigurationKey(TESTKEY);
        ConfigurationKey kd = k1.differenceKey(k1);
        Assert.assertEquals((long)0L, (long)kd.length());
        ConfigurationKey k2 = new ConfigurationKey("tables.table(0).name");
        kd = k1.differenceKey(k2);
        Assert.assertEquals((Object)"name", (Object)kd.toString());
        k2 = new ConfigurationKey("tables.table(1).fields.field(1)");
        kd = k1.differenceKey(k2);
        Assert.assertEquals((Object)"table(1).fields.field(1)", (Object)kd.toString());
        k2 = new ConfigurationKey("completely.different.key");
        kd = k1.differenceKey(k2);
        Assert.assertEquals((Object)k2, (Object)kd);
    }

    @Test
    public void testEscapedDelimiters() {
        ConfigurationKey k = new ConfigurationKey();
        k.append("my..elem");
        k.append("trailing..dot..");
        k.append("strange");
        Assert.assertEquals((Object)"my..elem.trailing..dot...strange", (Object)k.toString());
        ConfigurationKey.KeyIterator kit = k.iterator();
        Assert.assertEquals((Object)"my.elem", (Object)kit.nextKey());
        Assert.assertEquals((Object)"trailing.dot.", (Object)kit.nextKey());
        Assert.assertEquals((Object)"strange", (Object)kit.nextKey());
        Assert.assertFalse((boolean)kit.hasNext());
    }

    @Test
    public void testIterateStrangeKeys() {
        ConfigurationKey k = new ConfigurationKey("key.");
        ConfigurationKey.KeyIterator it = k.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"key", (Object)it.next());
        Assert.assertFalse((boolean)it.hasNext());
        k = new ConfigurationKey(".");
        it = k.iterator();
        Assert.assertFalse((boolean)it.hasNext());
        k = new ConfigurationKey("key().index()undefined(0).test");
        it = k.iterator();
        Assert.assertEquals((Object)"key()", (Object)it.next());
        Assert.assertFalse((boolean)it.hasIndex());
        Assert.assertEquals((Object)"index()undefined", (Object)it.nextKey(false));
        Assert.assertTrue((boolean)it.hasIndex());
        Assert.assertEquals((long)0L, (long)it.getIndex());
    }

    @Test
    public void testAttributeKeyWithIndex() {
        ConfigurationKey k = new ConfigurationKey(TESTATTR);
        k.appendIndex(0);
        Assert.assertEquals((String)"Wrong attribute key with index", (Object)"[@dataType](0)", (Object)k.toString());
        ConfigurationKey.KeyIterator it = k.iterator();
        Assert.assertTrue((String)"No first element", (boolean)it.hasNext());
        it.next();
        Assert.assertTrue((String)"Index not found", (boolean)it.hasIndex());
        Assert.assertEquals((String)"Incorrect index", (long)0L, (long)it.getIndex());
        Assert.assertTrue((String)"Attribute not found", (boolean)it.isAttribute());
        Assert.assertEquals((String)"Wrong plain key", (Object)"dataType", (Object)it.currentKey(false));
        Assert.assertEquals((String)"Wrong decorated key", (Object)TESTATTR, (Object)it.currentKey(true));
    }
}

