/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.INIConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestINIConfiguration {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String INI_DATA = "[section1]" + LINE_SEPARATOR + "var1 = foo" + LINE_SEPARATOR + "var2 = 451" + LINE_SEPARATOR + LINE_SEPARATOR + "[section2]" + LINE_SEPARATOR + "var1 = 123.45" + LINE_SEPARATOR + "var2 = bar" + LINE_SEPARATOR + LINE_SEPARATOR + "[section3]" + LINE_SEPARATOR + "var1 = true" + LINE_SEPARATOR + "interpolated = ${section3.var1}" + LINE_SEPARATOR + "multi = foo" + LINE_SEPARATOR + "multi = bar" + LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String INI_DATA2 = "[section4]" + LINE_SEPARATOR + "var1 = \"quoted value\"" + LINE_SEPARATOR + "var2 = \"quoted value\\nwith \\\"quotes\\\"\"" + LINE_SEPARATOR + "var3 = 123 ; comment" + LINE_SEPARATOR + "var4 = \"1;2;3\" ; comment" + LINE_SEPARATOR + "var5 = '\\'quoted\\' \"value\"' ; comment";

    @Test
    public void testSave() throws Exception {
        StringWriter writer = new StringWriter();
        INIConfiguration instance = new INIConfiguration();
        instance.addProperty("section1.var1", (Object)"foo");
        instance.addProperty("section1.var2", (Object)"451");
        instance.addProperty("section2.var1", (Object)"123.45");
        instance.addProperty("section2.var2", (Object)"bar");
        instance.addProperty("section3.var1", (Object)"true");
        instance.addProperty("section3.interpolated", (Object)"${section3.var1}");
        instance.addProperty("section3.multi", (Object)"foo");
        instance.addProperty("section3.multi", (Object)"bar");
        instance.save((Writer)writer);
        Assert.assertEquals((String)"Wrong content of ini file", (Object)INI_DATA, (Object)((Object)writer).toString());
    }

    @Test
    public void testLoad() throws Exception {
        this.checkLoad(INI_DATA);
    }

    @Test
    public void testLoadAlternativeSeparator() throws Exception {
        this.checkLoad(INI_DATA.replace('=', ':'));
    }

    private void checkLoad(String data) throws ConfigurationException, IOException {
        StringReader reader = new StringReader(data);
        INIConfiguration instance = new INIConfiguration();
        instance.load((Reader)reader);
        ((Reader)reader).close();
        Assert.assertTrue((boolean)instance.getString("section1.var1").equals("foo"));
        Assert.assertTrue((instance.getInt("section1.var2") == 451 ? 1 : 0) != 0);
        Assert.assertTrue((instance.getDouble("section2.var1") == 123.45 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)instance.getString("section2.var2").equals("bar"));
        Assert.assertTrue((boolean)instance.getBoolean("section3.var1"));
        Assert.assertTrue((instance.getSections().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testIsCommentLine() {
        INIConfiguration instance = new INIConfiguration();
        Assert.assertTrue((boolean)instance.isCommentLine("#comment1"));
        Assert.assertTrue((boolean)instance.isCommentLine(";comment1"));
        Assert.assertFalse((boolean)instance.isCommentLine("nocomment=true"));
        Assert.assertFalse((boolean)instance.isCommentLine(null));
    }

    @Test
    public void testIsSectionLine() {
        INIConfiguration instance = new INIConfiguration();
        Assert.assertTrue((boolean)instance.isSectionLine("[section]"));
        Assert.assertFalse((boolean)instance.isSectionLine("nosection=true"));
        Assert.assertFalse((boolean)instance.isSectionLine(null));
    }

    @Test
    public void testGetSections() {
        INIConfiguration instance = new INIConfiguration();
        instance.addProperty("test1.foo", (Object)"bar");
        instance.addProperty("test2.foo", (Object)"abc");
        HashSet<String> expResult = new HashSet<String>();
        expResult.add("test1");
        expResult.add("test2");
        Set result = instance.getSections();
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testQuotedValue() throws Exception {
        INIConfiguration config = new INIConfiguration();
        config.load((Reader)new StringReader(INI_DATA2));
        Assert.assertEquals((String)"value", (Object)"quoted value", (Object)config.getString("section4.var1"));
    }

    @Test
    public void testQuotedValueWithQuotes() throws Exception {
        INIConfiguration config = new INIConfiguration();
        config.load((Reader)new StringReader(INI_DATA2));
        Assert.assertEquals((String)"value", (Object)"quoted value\\nwith \"quotes\"", (Object)config.getString("section4.var2"));
    }

    @Test
    public void testValueWithComment() throws Exception {
        INIConfiguration config = new INIConfiguration();
        config.load((Reader)new StringReader(INI_DATA2));
        Assert.assertEquals((String)"value", (Object)"123", (Object)config.getString("section4.var3"));
    }

    @Test
    public void testQuotedValueWithComment() throws Exception {
        INIConfiguration config = new INIConfiguration();
        config.load((Reader)new StringReader(INI_DATA2));
        Assert.assertEquals((String)"value", (Object)"1;2;3", (Object)config.getString("section4.var4"));
    }

    @Test
    public void testQuotedValueWithSingleQuotes() throws Exception {
        INIConfiguration config = new INIConfiguration();
        config.load((Reader)new StringReader(INI_DATA2));
        Assert.assertEquals((String)"value", (Object)"'quoted' \"value\"", (Object)config.getString("section4.var5"));
    }

    @Test
    public void testWriteValueWithCommentChar() throws Exception {
        INIConfiguration config = new INIConfiguration();
        config.setProperty("section.key1", (Object)"1;2;3");
        StringWriter writer = new StringWriter();
        config.save((Writer)writer);
        INIConfiguration config2 = new INIConfiguration();
        config2.load((Reader)new StringReader(writer.toString()));
        Assert.assertEquals((String)"value", (Object)"1;2;3", (Object)config2.getString("section.key1"));
    }

    @Test
    public void testQuotedValueWithWhitespace() throws Exception {
        String content = "CmdPrompt = \" [test@cmd ~]$ \"";
        INIConfiguration config = new INIConfiguration();
        config.load((Reader)new StringReader("CmdPrompt = \" [test@cmd ~]$ \""));
        Assert.assertEquals((String)"Wrong propert value", (Object)" [test@cmd ~]$ ", (Object)config.getString("CmdPrompt"));
    }

    @Test
    public void testQuotedValueWithWhitespaceAndComment() throws Exception {
        String content = "CmdPrompt = \" [test@cmd ~]$ \" ; a comment";
        INIConfiguration config = new INIConfiguration();
        config.load((Reader)new StringReader("CmdPrompt = \" [test@cmd ~]$ \" ; a comment"));
        Assert.assertEquals((String)"Wrong propert value", (Object)" [test@cmd ~]$ ", (Object)config.getString("CmdPrompt"));
    }
}

