/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.event;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.event.AbstractTestConfigurationEvents;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.junit.Test;

public abstract class AbstractTestFileConfigurationEvents
extends AbstractTestConfigurationEvents {
    protected void setUpFileConfiguration() throws ConfigurationException, IOException {
        FileConfiguration fc = (FileConfiguration)this.config;
        fc.setReloadingStrategy((ReloadingStrategy)new AlwaysReloadingStrategy());
        fc.setURL(this.getSourceURL());
        this.config.removeConfigurationListener((ConfigurationListener)this.l);
        fc.load();
        this.config.addConfigurationListener((ConfigurationListener)this.l);
    }

    protected abstract URL getSourceURL() throws IOException;

    @Test
    public void testReloadEvent() throws ConfigurationException, IOException {
        this.setUpFileConfiguration();
        this.config.isEmpty();
        this.l.checkEvent(20, null, this.getSourceURL(), true);
        this.l.checkEvent(20, null, this.getSourceURL(), false);
        this.l.done();
    }

    @Test
    public void testReloadEventWithDetails() throws ConfigurationException, IOException {
        this.setUpFileConfiguration();
        this.config.setDetailEvents(true);
        this.config.isEmpty();
        this.l.checkEventCount(2);
        this.l.checkEvent(20, null, this.getSourceURL(), true);
        this.l.skipToLast(20);
        this.l.checkEvent(20, null, this.getSourceURL(), false);
        this.l.done();
    }

    @Test
    public void testAccessPropertiesOnReload() throws ConfigurationException, IOException {
        this.setUpFileConfiguration();
        this.config.addConfigurationListener(new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
                AbstractTestFileConfigurationEvents.this.config.getString("test");
            }
        });
        this.config.isEmpty();
        this.l.checkEvent(20, null, this.getSourceURL(), true);
        this.l.checkEvent(20, null, this.getSourceURL(), false);
        this.l.done();
    }

    static class AlwaysReloadingStrategy
    implements ReloadingStrategy {
        AlwaysReloadingStrategy() {
        }

        public void setConfiguration(FileConfiguration configuration) {
        }

        public void init() {
        }

        public boolean reloadingRequired() {
            return true;
        }

        public void reloadingPerformed() {
        }
    }
}

