/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.reloading;

import java.io.File;
import java.io.FileWriter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.ManagedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.junit.Assert;
import org.junit.Test;

public class TestManagedReloadingStrategy {
    @Test
    public void testManagedRefresh() throws Exception {
        File file = new File("target/testReload.properties");
        if (file.exists()) {
            file.delete();
        }
        FileWriter out = new FileWriter(file);
        out.write("string=value1");
        out.flush();
        out.close();
        PropertiesConfiguration config = new PropertiesConfiguration("target/testReload.properties");
        ManagedReloadingStrategy strategy = new ManagedReloadingStrategy();
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        Assert.assertEquals((String)"Initial value", (Object)"value1", (Object)config.getString("string"));
        out = new FileWriter(file);
        out.write("string=value2");
        out.flush();
        out.close();
        Assert.assertEquals((String)"No automatic reloading", (Object)"value1", (Object)config.getString("string"));
        strategy.refresh();
        Assert.assertEquals((String)"Modified value with enabled reloading", (Object)"value2", (Object)config.getString("string"));
    }
}

