/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLDocumentHelper;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TestXMLDocumentHelper {
    private static final String ELEMENT = "testElementName";
    private static final String TEST_FILE = "testcombine1.xml";

    private static String documentToString(Document document) throws ConfigurationException {
        Transformer transformer = XMLDocumentHelper.createTransformer();
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        XMLDocumentHelper.transform((Transformer)transformer, (Source)new DOMSource(document.getDocumentElement()), (Result)result);
        return writer.toString();
    }

    private static String documentToString(XMLDocumentHelper helper) throws ConfigurationException {
        return TestXMLDocumentHelper.documentToString(helper.getDocument());
    }

    private static Collection<Node> findTextElements(Document document) {
        HashSet<Node> texts = new HashSet<Node>();
        TestXMLDocumentHelper.findTextElementsForNode(document.getDocumentElement(), texts);
        return texts;
    }

    private static void findTextElementsForNode(Node node, Collection<Node> texts) {
        if (node instanceof Text) {
            texts.add(node);
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            TestXMLDocumentHelper.findTextElementsForNode(childNodes.item(i), texts);
        }
    }

    private static Document loadDocument() throws ParserConfigurationException, IOException, SAXException {
        return TestXMLDocumentHelper.loadDocument(TEST_FILE);
    }

    private static Document loadDocument(String name) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(ConfigurationAssert.getTestFile(name));
    }

    private void checkCopyElementMapping(String file) throws Exception {
        XMLDocumentHelper helper = XMLDocumentHelper.forSourceDocument((Document)TestXMLDocumentHelper.loadDocument(file));
        XMLDocumentHelper copy = helper.createCopy();
        Collection<Node> texts = TestXMLDocumentHelper.findTextElements(helper.getDocument());
        Assertions.assertFalse((boolean)texts.isEmpty());
        for (Node n : texts) {
            Text txtSrc = (Text)n;
            Text txtCopy = (Text)copy.getElementMapping().get(n);
            Assertions.assertNotNull((Object)txtCopy, (String)("No matching element for " + n));
            Assertions.assertEquals((Object)txtSrc.getData(), (Object)txtCopy.getData());
        }
    }

    @Test
    void testCopyDocument() throws Exception {
        XMLDocumentHelper helper = XMLDocumentHelper.forSourceDocument((Document)TestXMLDocumentHelper.loadDocument());
        XMLDocumentHelper copy = helper.createCopy();
        Assertions.assertNotSame((Object)helper.getDocument(), (Object)copy.getDocument());
        String doc1 = TestXMLDocumentHelper.documentToString(helper);
        String doc2 = TestXMLDocumentHelper.documentToString(copy);
        Assertions.assertEquals((Object)doc1, (Object)doc2);
    }

    @Test
    void testCopyElementMapping() throws Exception {
        this.checkCopyElementMapping(TEST_FILE);
    }

    @Test
    void testCopyElementMappingForComplexDocument() throws Exception {
        this.checkCopyElementMapping("test.xml");
    }

    @Test
    void testCreateDocumentBuilderFromFactoryException() throws ParserConfigurationException {
        DocumentBuilderFactory factory = (DocumentBuilderFactory)Mockito.mock(DocumentBuilderFactory.class);
        ParserConfigurationException pcex = new ParserConfigurationException();
        Mockito.when((Object)factory.newDocumentBuilder()).thenThrow(new Throwable[]{pcex});
        ConfigurationException cex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> XMLDocumentHelper.createDocumentBuilder((DocumentBuilderFactory)factory));
        Assertions.assertEquals((Object)pcex, (Object)cex.getCause());
    }

    @Test
    void testCreateTransformerFactory() {
        Assertions.assertNotNull((Object)XMLDocumentHelper.createTransformerFactory());
    }

    @Test
    void testCreateTransformerFactoryException() throws TransformerConfigurationException {
        TransformerFactory factory = (TransformerFactory)Mockito.mock(TransformerFactory.class);
        TransformerConfigurationException cause = new TransformerConfigurationException();
        Mockito.when((Object)factory.newTransformer()).thenThrow(new Throwable[]{cause});
        ConfigurationException cex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> XMLDocumentHelper.createTransformer((TransformerFactory)factory));
        Assertions.assertEquals((Object)cause, (Object)cex.getCause());
    }

    @Test
    void testElementMappingForNewDocument() throws ConfigurationException {
        XMLDocumentHelper helper = XMLDocumentHelper.forNewDocument((String)ELEMENT);
        Assertions.assertTrue((boolean)helper.getElementMapping().isEmpty());
    }

    @Test
    void testElementMappingForSourceDocument() throws Exception {
        Document doc = TestXMLDocumentHelper.loadDocument();
        XMLDocumentHelper helper = XMLDocumentHelper.forSourceDocument((Document)doc);
        Assertions.assertTrue((boolean)helper.getElementMapping().isEmpty());
    }

    @Test
    void testInitForNewDocument() throws ConfigurationException {
        XMLDocumentHelper helper = XMLDocumentHelper.forNewDocument((String)ELEMENT);
        Document doc = helper.getDocument();
        Element rootElement = doc.getDocumentElement();
        Assertions.assertEquals((Object)ELEMENT, (Object)rootElement.getNodeName());
        NodeList childNodes = rootElement.getChildNodes();
        Assertions.assertEquals((int)0, (int)childNodes.getLength());
        Assertions.assertNull((Object)helper.getSourcePublicID());
        Assertions.assertNull((Object)helper.getSourceSystemID());
    }

    @Test
    void testInitForSourceDocument() throws Exception {
        Document doc = TestXMLDocumentHelper.loadDocument();
        XMLDocumentHelper helper = XMLDocumentHelper.forSourceDocument((Document)doc);
        Assertions.assertNotSame((Object)doc, (Object)helper.getDocument());
        Assertions.assertEquals((Object)TestXMLDocumentHelper.documentToString(doc), (Object)TestXMLDocumentHelper.documentToString(helper));
    }

    @Test
    void testTransformException() throws TransformerException {
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Source src = (Source)Mockito.mock(Source.class);
        Result res = (Result)Mockito.mock(Result.class);
        TransformerException tex = new TransformerException("Test Exception");
        ((Transformer)Mockito.doThrow((Throwable[])new Throwable[]{tex}).when((Object)transformer)).transform(src, res);
        ConfigurationException cex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> XMLDocumentHelper.transform((Transformer)transformer, (Source)src, (Result)res));
        Assertions.assertEquals((Object)tex, (Object)cex.getCause());
    }
}

