/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDeloldrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewsuperiorLine;

public class LdifChangeModDnRecord
extends LdifChangeRecord {
    public LdifChangeModDnRecord(LdifDnLine dn) {
        super(dn);
    }

    public void setNewrdn(LdifNewrdnLine newrdn) {
        if (newrdn == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(newrdn);
    }

    public void setDeloldrdn(LdifDeloldrdnLine deloldrdn) {
        if (deloldrdn == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(deloldrdn);
    }

    public void setNewsuperior(LdifNewsuperiorLine newsuperior) {
        if (newsuperior == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(newsuperior);
    }

    public LdifNewrdnLine getNewrdnLine() {
        for (LdifPart part : this.ldifParts) {
            if (!(part instanceof LdifNewrdnLine)) continue;
            return (LdifNewrdnLine)part;
        }
        return null;
    }

    public LdifDeloldrdnLine getDeloldrdnLine() {
        for (Object part : this.ldifParts) {
            if (!(part instanceof LdifDeloldrdnLine)) continue;
            return (LdifDeloldrdnLine)part;
        }
        return null;
    }

    public LdifNewsuperiorLine getNewsuperiorLine() {
        for (Object part : this.ldifParts) {
            if (!(part instanceof LdifNewsuperiorLine)) continue;
            return (LdifNewsuperiorLine)part;
        }
        return null;
    }

    public static LdifChangeModDnRecord create(String dn) {
        LdifChangeModDnRecord record = new LdifChangeModDnRecord(LdifDnLine.create(dn));
        record.setChangeType(LdifChangeTypeLine.createModDn());
        return record;
    }

    @Override
    public boolean isValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        return this.getNewrdnLine() != null && this.getDeloldrdnLine() != null;
    }

    @Override
    public String getInvalidString() {
        if (this.getNewrdnLine() == null) {
            return "Missing new Rdn";
        }
        if (this.getDeloldrdnLine() == null) {
            return "Missing delete old Rdn";
        }
        return super.getInvalidString();
    }
}

