/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import java.sql.SQLException;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.db.exceptions.StatementFailedException;
import org.apache.empire.dbms.DBMSHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintViolationException
extends StatementFailedException {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ConstraintViolationException.class);
    public static final ErrorType errorType = new ErrorType("error.db.statementFailed", "Error executing statement {0}.\r\nNative error is: {1}");

    public ConstraintViolationException(DBMSHandler dbms, String sqlCmd, SQLException cause) {
        super(errorType, new String[]{sqlCmd, ConstraintViolationException.messageFromSQLException(dbms, cause)}, 1, cause);
    }

    @Override
    protected void log() {
        if (log.isErrorEnabled()) {
            log.error(this.getMessage());
        } else {
            super.log();
        }
    }
}

