/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.group.PGroup;

public final class DataCallback
extends MessageStream {
    private static final long serialVersionUID = 6512046150477794254L;
    private final Closure code;
    private final PGroup parallelGroup;

    public DataCallback(Closure code, PGroup pGroup) {
        if (pGroup == null) {
            throw new IllegalArgumentException("Cannot create a DataCallback without a parallelGroup parameter");
        }
        if (code.getMaximumNumberOfParameters() > 1) {
            throw new IllegalArgumentException("The supplied closure expects more than one argument.");
        }
        this.parallelGroup = pGroup;
        this.code = code;
    }

    @Override
    public MessageStream send(final Object message) {
        this.parallelGroup.getThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Dataflow.activeParallelGroup.set(DataCallback.this.parallelGroup);
                try {
                    if (DataCallback.this.code.getMaximumNumberOfParameters() == 1) {
                        DataCallback.this.code.call(message);
                    } else {
                        DataCallback.this.code.call();
                    }
                }
                finally {
                    Dataflow.activeParallelGroup.remove();
                }
            }
        });
        return this;
    }
}

