/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.guacamole.properties.GuacamoleProperties;
import org.apache.guacamole.token.TokenName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemFileEnvironmentGuacamoleProperties
implements GuacamoleProperties {
    private static final Logger logger = LoggerFactory.getLogger(SystemFileEnvironmentGuacamoleProperties.class);

    public String getProperty(String name) {
        String filename = System.getenv(TokenName.canonicalize((String)name) + "_FILE");
        if (filename != null) {
            try {
                return Files.asCharSource((File)new File(filename), (Charset)StandardCharsets.UTF_8).read();
            }
            catch (IOException e) {
                logger.error("Property \"{}\" could not be read from file \"{}\": {}", new Object[]{name, filename, e.getMessage()});
                logger.debug("Error reading property value from file.", (Throwable)e);
            }
        }
        return null;
    }
}

