/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.sharingprofile;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.SharingProfile;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;
import org.apache.guacamole.rest.sharingprofile.APISharingProfile;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SharingProfileResource
extends DirectoryObjectResource<SharingProfile, APISharingProfile> {
    @AssistedInject
    public SharingProfileResource(@Assisted AuthenticatedUser authenticatedUser, @Assisted UserContext userContext, @Assisted Directory<SharingProfile> directory, @Assisted SharingProfile sharingProfile, DirectoryObjectTranslator<SharingProfile, APISharingProfile> translator) {
        super(authenticatedUser, userContext, SharingProfile.class, directory, (Identifiable)sharingProfile, translator);
    }

    @GET
    @Path(value="parameters")
    public Map<String, String> getParameters() throws GuacamoleException {
        SharingProfile sharingProfile = (SharingProfile)this.getInternalObject();
        Permissions effective = this.getUserContext().self().getEffectivePermissions();
        SystemPermissionSet systemPermissions = effective.getSystemPermissions();
        ObjectPermissionSet sharingProfilePermissions = effective.getSharingProfilePermissions();
        String identifier = sharingProfile.getIdentifier();
        if (!systemPermissions.hasPermission(SystemPermission.Type.ADMINISTER) && !sharingProfilePermissions.hasPermission(ObjectPermission.Type.UPDATE, identifier)) {
            throw new GuacamoleSecurityException("Permission to read sharing profile parameters denied.");
        }
        return sharingProfile.getParameters();
    }
}

