/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.io.LimitedInputStream;
import org.junit.Assert;
import org.junit.Test;

public class LimitedInputStreamTest {
    @Test
    public void testUpToLimitRead() throws IOException {
        byte[] data = new byte[]{48, 49, 50, 51, 52, 53, 54};
        LimitedInputStream limitedStream = new LimitedInputStream(InputStreams.create((byte[])data), 3L);
        Assert.assertEquals((long)0L, (long)limitedStream.getPosition());
        Assert.assertTrue((limitedStream.read() != -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)limitedStream.getPosition());
        byte[] tmp = new byte[3];
        Assert.assertEquals((long)2L, (long)limitedStream.read(tmp));
        Assert.assertEquals((long)3L, (long)limitedStream.getPosition());
        try {
            limitedStream.read();
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            limitedStream.read(tmp);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            limitedStream.skip(2L);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        limitedStream.close();
    }
}

