/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.util;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ServiceLoader;

class FactoryFinder {
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "org.glassfish.hk2.osgiresourcelocator.ServiceLoader";

    FactoryFinder() {
    }

    static <T> T find(Class<T> factoryClass) throws RuntimeException {
        T result;
        T result2;
        String factoryId = factoryClass.getName();
        String className = FactoryFinder.fromSystemProperty(factoryId);
        if (className != null && (result2 = FactoryFinder.newInstance(className)) != null) {
            return result2;
        }
        T factory = FactoryFinder.factoryFromServiceLoader(factoryClass);
        if (factory != null) {
            return factory;
        }
        if (FactoryFinder.isHk2Available() && (result = FactoryFinder.lookupUsingHk2ServiceLoader(factoryId)) != null) {
            return result;
        }
        throw new IllegalStateException("Not provider of " + factoryClass.getName() + " was found");
    }

    private static <T> T newInstance(String className) throws RuntimeException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        FactoryFinder.checkPackageAccess(className);
        Class<?> clazz = null;
        try {
            clazz = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return (T)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot instance " + className, e);
        }
    }

    private static String fromSystemProperty(String factoryId) {
        String systemProp = System.getProperty(factoryId);
        return systemProp;
    }

    private static boolean isHk2Available() {
        try {
            Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static <T> T lookupUsingHk2ServiceLoader(String factoryId) {
        try {
            Class<?> serviceClass = Class.forName(factoryId);
            Class[] args = new Class[]{serviceClass};
            Class<?> target = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method m4 = target.getMethod("lookupProviderInstances", Class.class);
            Iterable iterable = (Iterable)m4.invoke(null, (Object[])args);
            if (iterable == null) {
                return null;
            }
            Iterator iter = iterable.iterator();
            return iter.hasNext() ? (T)iter.next() : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static <T> T factoryFromServiceLoader(Class<T> factory) {
        try {
            ServiceLoader<T> sl = ServiceLoader.load(factory);
            Iterator<T> iter = sl.iterator();
            if (iter.hasNext()) {
                return iter.next();
            }
            return null;
        }
        catch (Throwable t2) {
            throw new IllegalStateException("Cannot load " + factory + " as ServiceLoader", t2);
        }
    }

    private static void checkPackageAccess(String className) {
        int i;
        SecurityManager s2 = System.getSecurityManager();
        if (s2 != null && (i = className.lastIndexOf(46)) != -1) {
            s2.checkPackageAccess(className.substring(0, i));
        }
    }
}

