/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;

public class MimeMessageUtil {
    public static String asString(MimeMessage mimeMessage) throws Exception {
        return new String(MimeMessageUtil.asBytes(mimeMessage), StandardCharsets.UTF_8);
    }

    public static byte[] asBytes(MimeMessage mimeMessage) throws Exception {
        UnsynchronizedByteArrayOutputStream byteArrayOutputStream = new UnsynchronizedByteArrayOutputStream();
        mimeMessage.writeTo(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static MimeMessage defaultMimeMessage() {
        return new MimeMessage(Session.getDefaultInstance(new Properties()));
    }

    public static MimeMessage mimeMessageFromStream(InputStream inputStream) throws MessagingException {
        return new MimeMessage(Session.getDefaultInstance(new Properties()), inputStream);
    }

    public static MimeMessage mimeMessageFromBytes(byte[] bytes) throws MessagingException {
        return MimeMessageUtil.mimeMessageFromStream(new ByteArrayInputStream(bytes));
    }

    public static MimeMessage mimeMessageFromString(String string) throws MessagingException {
        return MimeMessageUtil.mimeMessageFromBytes(string.getBytes(StandardCharsets.UTF_8));
    }
}

