/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.imap.protocol;

import java.util.ArrayList;
import org.eclipse.angus.mail.iap.ProtocolException;
import org.eclipse.angus.mail.iap.Response;
import org.eclipse.angus.mail.imap.protocol.BASE64MailboxDecoder;

public class Namespaces {
    public Namespace[] personal;
    public Namespace[] otherUsers;
    public Namespace[] shared;

    public Namespaces(Response r) throws ProtocolException {
        this.personal = this.getNamespaces(r);
        this.otherUsers = this.getNamespaces(r);
        this.shared = this.getNamespaces(r);
    }

    private Namespace[] getNamespaces(Response r) throws ProtocolException {
        if (r.isNextNonSpace('(')) {
            ArrayList<Namespace> v = new ArrayList<Namespace>();
            do {
                Namespace ns = new Namespace(r);
                v.add(ns);
            } while (!r.isNextNonSpace(')'));
            return v.toArray(new Namespace[0]);
        }
        String s2 = r.readAtom();
        if (s2 == null) {
            throw new ProtocolException("Expected NIL, got null");
        }
        if (!s2.equalsIgnoreCase("NIL")) {
            throw new ProtocolException("Expected NIL, got " + s2);
        }
        return null;
    }

    public static class Namespace {
        public String prefix;
        public char delimiter;

        public Namespace(Response r) throws ProtocolException {
            if (!r.isNextNonSpace('(')) {
                throw new ProtocolException("Missing '(' at start of Namespace");
            }
            this.prefix = r.readString();
            if (!r.supportsUtf8()) {
                this.prefix = BASE64MailboxDecoder.decode(this.prefix);
            }
            r.skipSpaces();
            if (r.peekByte() == 34) {
                r.readByte();
                this.delimiter = (char)r.readByte();
                if (this.delimiter == '\\') {
                    this.delimiter = (char)r.readByte();
                }
                if (r.readByte() != 34) {
                    throw new ProtocolException("Missing '\"' at end of QUOTED_CHAR");
                }
            } else {
                String s2 = r.readAtom();
                if (s2 == null) {
                    throw new ProtocolException("Expected NIL, got null");
                }
                if (!s2.equalsIgnoreCase("NIL")) {
                    throw new ProtocolException("Expected NIL, got " + s2);
                }
                this.delimiter = '\u0000';
            }
            if (r.isNextNonSpace(')')) {
                return;
            }
            r.readString();
            r.skipSpaces();
            r.readStringList();
            if (!r.isNextNonSpace(')')) {
                throw new ProtocolException("Missing ')' at end of Namespace");
            }
        }
    }
}

