/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jdbc.appender;

import java.util.Arrays;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.jdbc.appender.ColumnConfig;
import org.apache.logging.log4j.jdbc.appender.ConnectionSource;
import org.apache.logging.log4j.jdbc.appender.JdbcDatabaseManager;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.util.Assert;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="JDBC")
public final class JdbcAppender
extends AbstractDatabaseAppender<JdbcDatabaseManager> {
    private final String description = this.getName() + "{ manager=" + this.getManager() + " }";

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private JdbcAppender(String name, Filter filter, Layout layout, boolean ignoreExceptions, Property[] properties, JdbcDatabaseManager manager) {
        super(name, filter, layout, ignoreExceptions, properties, (AbstractDatabaseManager)manager);
    }

    public String toString() {
        return this.description;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<JdbcAppender> {
        @PluginElement(value="ConnectionSource")
        @Required(message="No ConnectionSource provided")
        private @PluginElement(value="ConnectionSource") ConnectionSource connectionSource;
        @PluginBuilderAttribute
        private boolean immediateFail;
        @PluginBuilderAttribute
        private int bufferSize;
        @PluginBuilderAttribute
        @Required(message="No table name provided")
        private String tableName;
        @PluginElement(value="ColumnConfigs")
        private @PluginElement(value="ColumnConfigs") ColumnConfig[] columnConfigs;
        @PluginElement(value="ColumnMappings")
        private @PluginElement(value="ColumnMappings") ColumnMapping[] columnMappings;
        @PluginBuilderAttribute
        private boolean truncateStrings = true;
        @PluginBuilderAttribute
        private long reconnectIntervalMillis = 5000L;

        public JdbcAppender build() {
            if (Assert.isEmpty((Object)this.columnConfigs) && Assert.isEmpty((Object)this.columnMappings)) {
                LOGGER.error("Cannot create JdbcAppender without any columns.");
                return null;
            }
            String managerName = "JdbcManager{name=" + this.getName() + ", bufferSize=" + this.bufferSize + ", tableName=" + this.tableName + ", columnConfigs=" + Arrays.toString(this.columnConfigs) + ", columnMappings=" + Arrays.toString(this.columnMappings) + "}";
            JdbcDatabaseManager manager = JdbcDatabaseManager.getManager(managerName, this.bufferSize, this.getLayout(), this.connectionSource, this.tableName, this.columnConfigs, this.columnMappings, this.immediateFail, this.reconnectIntervalMillis, this.truncateStrings, this.getConfiguration());
            if (manager == null) {
                return null;
            }
            return new JdbcAppender(this.getName(), this.getFilter(), this.getLayout(), this.isIgnoreExceptions(), this.getPropertyArray(), manager);
        }

        public long getReconnectIntervalMillis() {
            return this.reconnectIntervalMillis;
        }

        public boolean isImmediateFail() {
            return this.immediateFail;
        }

        public B setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setColumnConfigs(ColumnConfig ... columnConfigs) {
            this.columnConfigs = columnConfigs;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setColumnMappings(ColumnMapping ... columnMappings) {
            this.columnMappings = columnMappings;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setConnectionSource(ConnectionSource connectionSource) {
            this.connectionSource = connectionSource;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public void setImmediateFail(boolean immediateFail) {
            this.immediateFail = immediateFail;
        }

        public void setReconnectIntervalMillis(long reconnectIntervalMillis) {
            this.reconnectIntervalMillis = reconnectIntervalMillis;
        }

        public B setTableName(String tableName) {
            this.tableName = tableName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setTruncateStrings(boolean truncateStrings) {
            this.truncateStrings = truncateStrings;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

