/*
 * Decompiled with CFR 0.152.
 */
package cisco.infra.dft.mojo.mgmt;

import cisco.infra.dma.maven.mojo.AbstractDmaMojo;
import cisco.infra.dma.repo.Namespaces;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;

public class AuthManagementMojo
extends AbstractDmaMojo {
    protected String authzFile = null;
    protected String pomDir = null;
    private SVNConfigFile authzConfig;

    public void execute() throws MojoExecutionException {
        if (this.authzFile == null || "".equals(this.authzFile)) {
            throw new MojoExecutionException("authzFile can not be null");
        }
        File file = new File(this.authzFile);
        this.authzConfig = new SVNConfigFile(file);
        this.appendDmaOps();
        if (this.pomDir != null) {
            this.processPomDirectory();
        }
    }

    private void processPomDirectory() throws MojoExecutionException {
        File dir = new File(this.pomDir);
        if (!dir.isDirectory()) {
            throw new MojoExecutionException("POM Dir is not a dir. " + this.pomDir);
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        File[] files = dir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            File pom = files[i];
            this.appendPomInfo(pom);
        }
    }

    private void appendPomInfo(File pom) throws MojoExecutionException {
        MavenProject project = this.loadMavenProject(pom);
        String path = Namespaces.getDmaRepoPathForPom((MavenProject)project);
        this.authzConfig.setPropertyValue("cisco.repo:/" + path, "@dma-ops", "rw", false);
        List developers = project.getDevelopers();
        if (developers.size() > 0) {
            Iterator iterator = developers.iterator();
            while (iterator.hasNext()) {
                Developer developer = (Developer)iterator.next();
                String email = developer.getEmail();
                if (email == null) continue;
                this.authzConfig.setPropertyValue("cisco.repo:/" + path, email, "rw", false);
            }
        }
        this.authzConfig.save();
    }

    private MavenProject loadMavenProject(File pom) throws MojoExecutionException {
        FileReader reader = null;
        try {
            reader = new FileReader(pom);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("File no found.", (Exception)e);
        }
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = modelReader.read((Reader)reader);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not parse POM", e);
        }
        MavenProject project = new MavenProject(model);
        return project;
    }

    private void appendDmaOps() {
        this.authzConfig.setPropertyValue("groups", "dma-ops", "robevans,mharry", false);
        this.authzConfig.setPropertyValue("cisco.repo:/", "@dma-ops", "rw", false);
    }

    public String getAuthzFile() {
        return this.authzFile;
    }

    public void setAuthzFile(String authzFile) {
        this.authzFile = authzFile;
    }

    public String getPomDir() {
        return this.pomDir;
    }

    public void setPomDir(String pomDir) {
        this.pomDir = pomDir;
    }
}

