/*
 * Decompiled with CFR 0.152.
 */
package cisco.infra.dma.repo;

import cisco.infra.dma.repo.BadDmaName;
import cisco.infra.dma.repo.IRepoSpaceNames;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;

public class Namespaces
implements IRepoSpaceNames {
    private static StringBuffer descrition;

    public static boolean isFixedCategoryValid(String name) {
        if (name == null || name.equals("")) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isProjectSpaceValid(String artifactId) {
        if (artifactId == null || artifactId.equals("")) {
            return false;
        }
        if (artifactId.contains("-")) {
            return false;
        }
        if (!artifactId.equals(artifactId.toLowerCase())) {
            return false;
        }
        if (artifactId.contains(" ")) {
            return false;
        }
        return artifactId.replace(".", "").matches("\\p{Alnum}+");
    }

    public static String getFixedCategory(String category) throws BadDmaName {
        if (category == null || category.equals("")) {
            throw new BadDmaName();
        }
        for (int i = 0; i < names.length; ++i) {
            if (!category.startsWith(names[i])) continue;
            return names[i];
        }
        throw new BadDmaName();
    }

    public static String getSubjectArea(String groupId) throws BadDmaName {
        String fixed = Namespaces.getFixedCategory(groupId);
        if (fixed == null || "".equals(fixed)) {
            return null;
        }
        Pattern p = Pattern.compile("^" + fixed + ".");
        Matcher m = p.matcher(groupId);
        String subjectArea = m.replaceFirst("");
        if (subjectArea.equals(fixed)) {
            return "";
        }
        return subjectArea;
    }

    public static String getProjectSpace(String artifactId) {
        return artifactId;
    }

    public static String getDmaRepoPathForPom(MavenProject project) throws BadDmaName {
        String fixed = Namespaces.getFixedCategory(project.getGroupId());
        String subjectArea = Namespaces.getSubjectArea(project.getGroupId());
        String projectSpace = Namespaces.getProjectSpace(project.getArtifactId());
        return fixed + "/" + subjectArea + "/" + projectSpace;
    }

    public static String getSvnProjectSpaceRootPath(MavenProject project) throws BadDmaName {
        String fixed = Namespaces.getFixedCategory(project.getGroupId());
        String subjectArea = Namespaces.getSubjectArea(project.getGroupId());
        return fixed + "/" + subjectArea;
    }

    public static String getDmaRepoUrlForProject(Parent parent) throws BadDmaName {
        String fixed = Namespaces.getFixedCategory(parent.getGroupId());
        String subjectArea = Namespaces.getSubjectArea(parent.getGroupId());
        String projectSpace = Namespaces.getProjectSpace(parent.getArtifactId());
        return "http://releng.cisco.com/svn/cisco.repo/" + fixed + "/" + subjectArea + "/" + projectSpace;
    }

    public static String getDescriptionOfNamingConvention() {
        if (descrition == null) {
            descrition = new StringBuffer();
            Namespaces.loadDescription();
        }
        return descrition.toString();
    }

    private static void loadDescription() {
        descrition.append("Valid Names for GroupIds and Fixed Categories:\n");
        for (int i = 0; i < names.length; ++i) {
            descrition.append("\t" + names[i] + "\n");
        }
        descrition.append("\n Valid Names for Projects:\n");
        descrition.append("\t Format symbol[.symbol]* \n");
        descrition.append("\t Where symbol is alphanumeric text excluding numbers \n");
        descrition.append("\t Examples: \n");
        descrition.append("\n");
        descrition.append("\t dft.request.webapp \n");
        descrition.append("\t foo \n");
        descrition.append("\t foo.bar.baz \n");
    }
}

