/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.felix.bundlerepository.impl.CapabilityImpl;
import org.apache.felix.bundlerepository.impl.PropertyImpl;
import org.apache.felix.bundlerepository.impl.Referral;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.RepositoryParser;
import org.apache.felix.bundlerepository.impl.RequirementImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;

public class StaxParser
extends RepositoryParser {
    static XMLInputFactory factory;

    public static synchronized void setFactory(XMLInputFactory factory) {
        StaxParser.factory = factory;
    }

    public static synchronized XMLInputFactory getFactory() {
        if (factory == null) {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            StaxParser.setProperty(factory, "javax.xml.stream.isNamespaceAware", false);
            StaxParser.setProperty(factory, "javax.xml.stream.isValidating", false);
            StaxParser.setProperty(factory, "javax.xml.stream.isCoalescing", false);
            StaxParser.factory = factory;
        }
        return factory;
    }

    protected static boolean setProperty(XMLInputFactory factory, String name, boolean value) {
        try {
            factory.setProperty(name, value);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public RepositoryImpl parseRepository(InputStream is) throws Exception {
        XMLStreamReader reader = StaxParser.getFactory().createXMLStreamReader(is);
        int event = reader.nextTag();
        if (event != 1 || !"repository".equals(reader.getLocalName())) {
            throw new Exception("Expected element 'repository' at the root of the document");
        }
        return this.parseRepository(reader);
    }

    public RepositoryImpl parseRepository(Reader r) throws Exception {
        XMLStreamReader reader = StaxParser.getFactory().createXMLStreamReader(r);
        int event = reader.nextTag();
        if (event != 1 || !"repository".equals(reader.getLocalName())) {
            throw new Exception("Expected element 'repository' at the root of the document");
        }
        return this.parseRepository(reader);
    }

    public ResourceImpl parseResource(Reader r) throws Exception {
        XMLStreamReader reader = StaxParser.getFactory().createXMLStreamReader(r);
        int event = reader.nextTag();
        if (event != 1 || !"resource".equals(reader.getLocalName())) {
            throw new Exception("Expected element 'resource'");
        }
        return this.parseResource(reader);
    }

    public CapabilityImpl parseCapability(Reader r) throws Exception {
        XMLStreamReader reader = StaxParser.getFactory().createXMLStreamReader(r);
        int event = reader.nextTag();
        if (event != 1 || !"capability".equals(reader.getLocalName())) {
            throw new Exception("Expected element 'capability'");
        }
        return this.parseCapability(reader);
    }

    public PropertyImpl parseProperty(Reader r) throws Exception {
        XMLStreamReader reader = StaxParser.getFactory().createXMLStreamReader(r);
        int event = reader.nextTag();
        if (event != 1 || !"p".equals(reader.getLocalName())) {
            throw new Exception("Expected element 'p'");
        }
        return this.parseProperty(reader);
    }

    public RequirementImpl parseRequirement(Reader r) throws Exception {
        XMLStreamReader reader = StaxParser.getFactory().createXMLStreamReader(r);
        int event = reader.nextTag();
        if (event != 1 || !"require".equals(reader.getLocalName())) {
            throw new Exception("Expected element 'require'");
        }
        return this.parseRequire(reader);
    }

    public RepositoryImpl parseRepository(XMLStreamReader reader) throws Exception {
        int event;
        RepositoryImpl repository = new RepositoryImpl();
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if ("name".equals(name)) {
                repository.setName(value);
                continue;
            }
            if (!"lastmodified".equals(name)) continue;
            repository.setLastModified(value);
        }
        while ((event = reader.nextTag()) == 1) {
            String element = reader.getLocalName();
            if ("referral".equals(element)) {
                Referral referral = this.parseReferral(reader);
                repository.addReferral(referral);
                continue;
            }
            if ("resource".equals(element)) {
                ResourceImpl resource = this.parseResource(reader);
                repository.addResource(resource);
                continue;
            }
            this.ignoreTag(reader);
        }
        this.sanityCheckEndElement(reader, event, "repository");
        return repository;
    }

    private void sanityCheckEndElement(XMLStreamReader reader, int event, String element) {
        if (event != 2 || !element.equals(reader.getLocalName())) {
            throw new IllegalStateException("Unexpected state while finishing element " + element);
        }
    }

    private Referral parseReferral(XMLStreamReader reader) throws Exception {
        Referral referral = new Referral();
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if ("depth".equals(name)) {
                referral.setDepth(value);
                continue;
            }
            if (!"url".equals(name)) continue;
            referral.setUrl(value);
        }
        this.sanityCheckEndElement(reader, reader.nextTag(), "referral");
        return referral;
    }

    private ResourceImpl parseResource(XMLStreamReader reader) throws Exception {
        ResourceImpl resource = new ResourceImpl();
        try {
            int event;
            int nb = reader.getAttributeCount();
            for (int i = 0; i < nb; ++i) {
                resource.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
            }
            while ((event = reader.nextTag()) == 1) {
                String element = reader.getLocalName();
                if ("category".equals(element)) {
                    String category = this.parseCategory(reader);
                    resource.addCategory(category);
                    continue;
                }
                if ("capability".equals(element)) {
                    CapabilityImpl capability = this.parseCapability(reader);
                    resource.addCapability(capability);
                    continue;
                }
                if ("require".equals(element)) {
                    RequirementImpl requirement = this.parseRequire(reader);
                    resource.addRequire(requirement);
                    continue;
                }
                StringBuffer sb = null;
                String type = reader.getAttributeValue(null, "type");
                while ((event = reader.next()) != 2) {
                    switch (event) {
                        case 1: {
                            throw new Exception("Unexpected element inside <require/> element");
                        }
                        case 4: {
                            if (sb == null) {
                                sb = new StringBuffer();
                            }
                            sb.append(reader.getText());
                        }
                    }
                }
                if (sb == null) continue;
                resource.put(element, sb.toString().trim(), type);
            }
            if (event != 2 || !"resource".equals(reader.getLocalName())) {
                throw new Exception("Unexpected state");
            }
            return resource;
        }
        catch (Exception e) {
            Location loc = reader.getLocation();
            if (loc != null) {
                throw new Exception("Error while parsing resource " + resource.getId() + " at line " + loc.getLineNumber() + " and column " + loc.getColumnNumber(), e);
            }
            throw new Exception("Error while parsing resource " + resource.getId(), e);
        }
    }

    private String parseCategory(XMLStreamReader reader) throws XMLStreamException {
        String id = null;
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            if (!"id".equals(reader.getAttributeLocalName(i))) continue;
            id = reader.getAttributeValue(i);
        }
        this.sanityCheckEndElement(reader, reader.nextTag(), "category");
        return id;
    }

    private CapabilityImpl parseCapability(XMLStreamReader reader) throws Exception {
        int event;
        CapabilityImpl capability = new CapabilityImpl();
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (!"name".equals(name)) continue;
            capability.setName(value);
        }
        while ((event = reader.nextTag()) == 1) {
            String element = reader.getLocalName();
            if ("p".equals(element)) {
                PropertyImpl prop = this.parseProperty(reader);
                capability.addProperty(prop);
                continue;
            }
            this.ignoreTag(reader);
        }
        this.sanityCheckEndElement(reader, event, "capability");
        return capability;
    }

    private PropertyImpl parseProperty(XMLStreamReader reader) throws Exception {
        String n = null;
        String t = null;
        String v = null;
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if ("n".equals(name)) {
                n = value;
                continue;
            }
            if ("t".equals(name)) {
                t = value;
                continue;
            }
            if (!"v".equals(name)) continue;
            v = value;
        }
        PropertyImpl prop = new PropertyImpl(n, t, v);
        this.sanityCheckEndElement(reader, reader.nextTag(), "p");
        return prop;
    }

    private RequirementImpl parseRequire(XMLStreamReader reader) throws Exception {
        int event;
        RequirementImpl requirement = new RequirementImpl();
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if ("name".equals(name)) {
                requirement.setName(value);
                continue;
            }
            if ("filter".equals(name)) {
                requirement.setFilter(value);
                continue;
            }
            if ("extend".equals(name)) {
                requirement.setExtend(Boolean.parseBoolean(value));
                continue;
            }
            if ("multiple".equals(name)) {
                requirement.setMultiple(Boolean.parseBoolean(value));
                continue;
            }
            if (!"optional".equals(name)) continue;
            requirement.setOptional(Boolean.parseBoolean(value));
        }
        StringBuffer sb = null;
        while ((event = reader.next()) != 2) {
            switch (event) {
                case 1: {
                    throw new Exception("Unexpected element inside <require/> element");
                }
                case 4: {
                    if (sb == null) {
                        sb = new StringBuffer();
                    }
                    sb.append(reader.getText());
                }
            }
        }
        if (sb != null) {
            requirement.addText(sb.toString());
        }
        this.sanityCheckEndElement(reader, event, "require");
        return requirement;
    }

    private void ignoreTag(XMLStreamReader reader) throws XMLStreamException {
        int level = 1;
        int event = 0;
        while (level > 0) {
            event = reader.next();
            if (event == 1) {
                ++level;
                continue;
            }
            if (event != 2) continue;
            --level;
        }
    }
}

