/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import org.testng.ISuite;
import org.testng.remote.strprotocol.IStringMessage;

public class SuiteMessage
implements IStringMessage {
    protected final String m_suiteName;
    protected final int m_testMethodCount;
    protected final boolean m_startSuite;

    SuiteMessage(String suiteName, boolean startSuiteRun, int methodCount) {
        this.m_suiteName = suiteName;
        this.m_startSuite = startSuiteRun;
        this.m_testMethodCount = methodCount;
    }

    public SuiteMessage(ISuite suite, boolean startSuiteRun) {
        this.m_suiteName = suite.getName();
        this.m_testMethodCount = suite.getInvokedMethods().size();
        this.m_startSuite = startSuiteRun;
    }

    public boolean isMessageOnStart() {
        return this.m_startSuite;
    }

    public String getSuiteName() {
        return this.m_suiteName;
    }

    public int getTestMethodCount() {
        return this.m_testMethodCount;
    }

    public String getMessageAsString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_startSuite ? 11 : 12).append('\u0001').append(this.m_suiteName).append('\u0001').append(this.m_testMethodCount);
        return buf.toString();
    }
}

