/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.model;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.DataModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.cdi.model.DataModelBuilder;

@ApplicationScoped
public class FacesDataModelClassBeanHolder
extends DataModelBuilder {
    private volatile Map<Class<?>, Class<? extends DataModel>> classInstanceToDataModelWrapperClassMap = new ConcurrentHashMap();
    private Map<Class<?>, Class<? extends DataModel>> umclassInstanceToDataModelWrapperClassMap = null;

    public Map<Class<?>, Class<? extends DataModel>> getClassInstanceToDataModelWrapperClassMap() {
        if (this.umclassInstanceToDataModelWrapperClassMap == null) {
            this.umclassInstanceToDataModelWrapperClassMap = Collections.unmodifiableMap(this.classInstanceToDataModelWrapperClassMap);
        }
        return this.umclassInstanceToDataModelWrapperClassMap;
    }

    public void addFacesDataModel(Class<?> forClass, Class<? extends DataModel> dataModelClass) {
        this.classInstanceToDataModelWrapperClassMap.put(forClass, dataModelClass);
    }

    @Override
    public DataModel createDataModel(FacesContext facesContext, Class<?> forClass, Object value) {
        Class<? extends DataModel> dataModelClass = this.getClassInstanceToDataModelWrapperClassMap().get(forClass);
        if (dataModelClass != null) {
            return this.createDataModel(forClass, value, dataModelClass);
        }
        Class<?> entryForClass = null;
        Class<? extends DataModel> valueForClass = null;
        for (Map.Entry<Class<?>, Class<DataModel>> entry : this.getClassInstanceToDataModelWrapperClassMap().entrySet()) {
            if (!entry.getKey().isAssignableFrom(forClass)) continue;
            if (entryForClass != null) {
                if (!entryForClass.isAssignableFrom(entry.getKey())) continue;
                entryForClass = entry.getKey();
                valueForClass = entry.getValue();
                continue;
            }
            entryForClass = entry.getKey();
            valueForClass = entry.getValue();
        }
        if (entryForClass != null) {
            return this.createDataModel(forClass, value, valueForClass);
        }
        return null;
    }

    private DataModel createDataModel(Class<?> forClass, Object value, Class<? extends DataModel> dataModelClass) {
        try {
            Constructor<Object> selectedConstructor = null;
            boolean equalsFound = false;
            for (Constructor<?> constructor : dataModelClass.getConstructors()) {
                if (constructor.getParameterCount() != 1) continue;
                if (constructor.getParameterTypes()[0].equals(forClass)) {
                    selectedConstructor = constructor;
                    equalsFound = true;
                    continue;
                }
                if (!constructor.getParameterTypes()[0].isAssignableFrom(forClass) || equalsFound) continue;
                selectedConstructor = constructor;
            }
            Constructor<? extends DataModel> constructor = null;
            if (selectedConstructor != null) {
                constructor = selectedConstructor;
                return constructor.newInstance(value);
            }
            constructor = dataModelClass.getConstructor(new Class[0]);
            DataModel dm = constructor.newInstance(new Object[0]);
            dm.setWrappedData(value);
            return dm;
        }
        catch (NoSuchMethodException ex) {
            throw new FacesException("Cannot find constructor of DataModel with " + forClass.getName() + " as parameter", (Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new FacesException("Cannot access constructor of DataModel with " + forClass.getName() + " as parameter", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new FacesException("Cannot access constructor of DataModel with " + forClass.getName() + " as parameter", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new FacesException("Cannot access constructor of DataModel with " + forClass.getName() + " as parameter", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new FacesException("Cannot find constructor of DataModel with " + forClass.getName() + " as parameter", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new FacesException("Cannot find constructor of DataModel with " + forClass.getName() + " as parameter", (Throwable)ex);
        }
    }
}

