/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Enumeration;
import org.apache.myfaces.config.ManagedBeanDestroyer;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.shared.context.ExceptionHandlerImpl;
import org.apache.myfaces.spi.ViewScopeProvider;

public class ManagedBeanDestroyerListener
implements HttpSessionAttributeListener,
HttpSessionListener,
ServletContextListener,
ServletContextAttributeListener,
ServletRequestListener,
ServletRequestAttributeListener {
    public static final String APPLICATION_MAP_KEY = ManagedBeanDestroyerListener.class.getName();
    private ManagedBeanDestroyer _destroyer = null;
    private ViewScopeProvider _viewScopeHandler = null;

    public void contextInitialized(ServletContextEvent event) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this._destroyer != null) {
            ServletContext ctx = event.getServletContext();
            Enumeration attributes = ctx.getAttributeNames();
            if (!attributes.hasMoreElements()) {
                return;
            }
            while (attributes.hasMoreElements()) {
                String name = (String)attributes.nextElement();
                Object value = ctx.getAttribute(name);
                this._destroyer.destroy(name, value);
            }
        }
    }

    public void setManagedBeanDestroyer(ManagedBeanDestroyer destroyer) {
        this._destroyer = destroyer;
    }

    public void setViewScopeHandler(ViewScopeProvider listener) {
        this._viewScopeHandler = listener;
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        if (this._viewScopeHandler != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext != null) {
                this._viewScopeHandler.onSessionDestroyed();
            } else {
                try {
                    ServletContext servletContext = event.getSession().getServletContext();
                    StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
                    externalContext.setSession(event.getSession());
                    ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
                    facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ReleaseableExternalContext)externalContext, exceptionHandler, false);
                    this._viewScopeHandler.onSessionDestroyed();
                }
                finally {
                    facesContext.release();
                }
            }
        }
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent event) {
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        if (this._destroyer != null) {
            this._destroyer.destroy(event.getName(), event.getValue());
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
    }

    public void requestDestroyed(ServletRequestEvent event) {
        if (this._destroyer != null) {
            ServletRequest request = event.getServletRequest();
            Enumeration attributes = request.getAttributeNames();
            if (!attributes.hasMoreElements()) {
                return;
            }
            while (attributes.hasMoreElements()) {
                String name = (String)attributes.nextElement();
                Object value = request.getAttribute(name);
                this._destroyer.destroy(name, value);
            }
        }
    }
}

