/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.application;

import jakarta.faces.context.FacesContext;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.io.IOException;
import java.util.Map;
import org.apache.myfaces.core.api.shared.lang.Assert;

public abstract class StateManager {
    public static final String STATE_SAVING_METHOD_PARAM_NAME = "jakarta.faces.STATE_SAVING_METHOD";
    public static final String STATE_SAVING_METHOD_CLIENT = "client";
    public static final String STATE_SAVING_METHOD_SERVER = "server";
    public static final String FULL_STATE_SAVING_VIEW_IDS_PARAM_NAME = "jakarta.faces.FULL_STATE_SAVING_VIEW_IDS";
    public static final String PARTIAL_STATE_SAVING_PARAM_NAME = "jakarta.faces.PARTIAL_STATE_SAVING";
    private Boolean _savingStateInClient = null;
    public static final String IS_BUILDING_INITIAL_STATE = "jakarta.faces.IS_BUILDING_INITIAL_STATE";
    public static final String IS_SAVING_STATE = "jakarta.faces.IS_SAVING_STATE";
    public static final String SERIALIZE_SERVER_STATE_PARAM_NAME = "jakarta.faces.SERIALIZE_SERVER_STATE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getViewState(FacesContext context) {
        Object savedView = null;
        if (context != null && !context.getViewRoot().isTransient()) {
            String viewId = context.getViewRoot().getViewId();
            ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, viewId);
            if (vdl != null) {
                Map<Object, Object> contextAttributes = context.getAttributes();
                try {
                    contextAttributes.put(IS_SAVING_STATE, Boolean.TRUE);
                    savedView = vdl.getStateManagementStrategy(context, viewId).saveView(context);
                }
                finally {
                    contextAttributes.remove(IS_SAVING_STATE);
                }
            }
        }
        return context.getRenderKit().getResponseStateManager().getViewState(context, savedView);
    }

    public boolean isSavingStateInClient(FacesContext context) {
        Assert.notNull(context, "context");
        if (this._savingStateInClient != null) {
            return this._savingStateInClient;
        }
        String stateSavingMethod = context.getExternalContext().getInitParameter(STATE_SAVING_METHOD_PARAM_NAME);
        if (stateSavingMethod == null) {
            this._savingStateInClient = Boolean.FALSE;
            context.getExternalContext().log("No state saving method defined, assuming default server state saving");
        } else if (stateSavingMethod.equalsIgnoreCase(STATE_SAVING_METHOD_CLIENT)) {
            this._savingStateInClient = Boolean.TRUE;
        } else if (stateSavingMethod.equalsIgnoreCase(STATE_SAVING_METHOD_SERVER)) {
            this._savingStateInClient = Boolean.FALSE;
        } else {
            this._savingStateInClient = Boolean.FALSE;
            context.getExternalContext().log("Illegal state saving method '" + stateSavingMethod + "', default server state saving will be used");
        }
        return this._savingStateInClient;
    }

    public void writeState(FacesContext context, Object state) throws IOException {
    }
}

