/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.activation;

import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.api.activation.ProjectStageActivated;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.api.startup.CodiStartupBroadcaster;
import org.apache.myfaces.extensions.cdi.core.impl.activation.PropertyExpressionInterpreter;
import org.apache.myfaces.extensions.cdi.core.impl.projectstage.ProjectStageProducer;
import org.apache.myfaces.extensions.cdi.core.impl.util.ActivationUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivationExtension
implements Extension,
Deactivatable {
    private static final Logger LOG = Logger.getLogger(ActivationExtension.class.getName());

    protected void initProjectStage(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        ProjectStageProducer.getInstance();
    }

    protected void vetoAlternativeTypes(@Observes ProcessAnnotatedType processAnnotatedType) {
        if (!this.isActivated()) {
            return;
        }
        CodiStartupBroadcaster.broadcastStartup();
        try {
            ProjectStage projectStage = ProjectStageProducer.getInstance().getProjectStage();
            this.checkProjectStageActivated(processAnnotatedType, projectStage);
            this.checkExpressionActivated(processAnnotatedType);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Invalid bean detected: " + processAnnotatedType.getAnnotatedType().getJavaClass().getName(), e);
        }
    }

    private void checkProjectStageActivated(ProcessAnnotatedType<?> processAnnotatedType, ProjectStage currentlyConfiguredProjectStage) {
        Class[] activatedIn;
        if (processAnnotatedType.getAnnotatedType().getJavaClass().isAnnotationPresent(ProjectStageActivated.class) && !this.isInProjectStage(activatedIn = processAnnotatedType.getAnnotatedType().getJavaClass().getAnnotation(ProjectStageActivated.class).value(), currentlyConfiguredProjectStage)) {
            processAnnotatedType.veto();
            LOG.finer("ProjectState Veto for bean with type: " + processAnnotatedType.getAnnotatedType().getJavaClass());
        }
    }

    private void checkExpressionActivated(ProcessAnnotatedType<?> processAnnotatedType) {
        Class annotatedClass = processAnnotatedType.getAnnotatedType().getJavaClass();
        if (!ActivationUtils.isActivated(annotatedClass, PropertyExpressionInterpreter.class)) {
            processAnnotatedType.veto();
            LOG.finer("Expression Veto for bean with type: " + processAnnotatedType.getAnnotatedType().getJavaClass());
        }
    }

    private boolean isInProjectStage(Class<? extends ProjectStage>[] activatedIn, ProjectStage currentlyConfiguredProjectStage) {
        if (activatedIn != null && activatedIn.length > 0) {
            for (Class<? extends ProjectStage> activated : activatedIn) {
                if (ProjectStage.class.getName().equals(activated.getName())) {
                    throw new IllegalStateException("Using " + ProjectStage.class.getName() + " directly isn't allowed.");
                }
                if (!currentlyConfiguredProjectStage.getClass().equals(activated)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(this.getClass());
    }
}

