/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.validation.message;

import javax.faces.application.FacesMessage;
import org.apache.myfaces.extensions.validator.core.validation.message.LabeledMessage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

@UsageInformation(value={UsageCategory.INTERNAL})
class ViolationMessage
extends FacesMessage
implements LabeledMessage {
    private static final long serialVersionUID = 6903958942987711231L;
    private String label;
    private boolean summaryLabelReplaced = false;
    private boolean detailLabelReplaced = false;

    public ViolationMessage(String summary, String detail) {
        this(SEVERITY_ERROR, summary, detail);
    }

    public ViolationMessage(FacesMessage.Severity severity, String summary, String detail) {
        this.setSeverity(severity);
        this.setSummary(summary);
        this.setDetail(detail);
    }

    public String getLabelText() {
        return this.label;
    }

    public void setLabelText(String label) {
        this.label = label;
    }

    public String getSummary() {
        if (this.label != null && !this.summaryLabelReplaced) {
            this.setSummary(this.getLabeledMesssage(super.getSummary(), this.getLabelText()));
            this.summaryLabelReplaced = true;
        }
        return super.getSummary();
    }

    public String getDetail() {
        if (this.label != null && !this.detailLabelReplaced) {
            this.setDetail(this.getLabeledMesssage(super.getDetail(), this.getLabelText()));
            this.detailLabelReplaced = true;
        }
        return super.getDetail();
    }

    private String getLabeledMesssage(String message, String label) {
        for (int i = 0; i < 3; ++i) {
            if (message == null || !message.contains("{" + i + "}")) continue;
            message = message.replace("{" + i + "}", label);
        }
        return message;
    }

    public void setSummary(String s) {
        super.setSummary(s);
        this.summaryLabelReplaced = false;
    }

    public void setDetail(String s) {
        super.setDetail(s);
        this.detailLabelReplaced = false;
    }
}

