/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.UISelectManyListbox;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.SelectManyRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.SelectItemUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectManyListboxRenderer
extends SelectManyRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectManyListboxRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UISelectManyListbox)) {
            LOG.error("Wrong type: Need " + UISelectManyListbox.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UISelectManyListbox select = (UISelectManyListbox)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String id = select.getClientId(facesContext);
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, (UIComponent)select);
        boolean readonly = select.isReadonly();
        boolean disabled = !items.iterator().hasNext() || select.isDisabled() || readonly;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        writer.startElement("select", (UIComponent)select);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        writer.writeAttribute("disabled", disabled);
        writer.writeAttribute("readonly", readonly);
        writer.writeAttribute("required", select.isRequired());
        HtmlRendererUtils.renderFocus(id, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
        Integer tabIndex = select.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        Style style = new Style(facesContext, (LayoutBase)select);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        writer.writeAttribute("multiple", "multiple", false);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        HtmlRendererUtils.renderCommandFacet((UIComponent)select, facesContext, writer);
        Object[] values = select.getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)select);
        HtmlRendererUtils.renderSelectItems((UIInput)select, items, values, submittedValues, writer, facesContext);
        writer.endElement("select");
    }
}

